"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewActivity = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _use_get_case_configuration = require("../../../containers/configure/use_get_case_configuration");
var _use_get_case_users = require("../../../containers/use_get_case_users");
var _use_get_case_connectors = require("../../../containers/use_get_case_connectors");
var _use_cases_features = require("../../../common/use_cases_features");
var _use_get_current_user_profile = require("../../../containers/user_profiles/use_get_current_user_profile");
var _use_get_supported_action_connectors = require("../../../containers/configure/use_get_supported_action_connectors");
var _edit_connector = require("../../edit_connector");
var _button = require("../../status/button");
var _edit_tags = require("./edit_tags");
var _user_actions = require("../../user_actions");
var _user_list = require("./user_list");
var _use_on_update_field = require("../use_on_update_field");
var _use_cases_context = require("../../cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("../translations"));
var _sidebar_selector = require("../../severity/sidebar_selector");
var _use_get_case_user_actions_stats = require("../../../containers/use_get_case_user_actions_stats");
var _assign_users = require("./assign_users");
var _user_actions_activity_bar = require("../../user_actions_activity_bar");
var _types = require("../../../../common/types");
var _case_view_tabs = require("../case_view_tabs");
var _description = require("../../description");
var _edit_category = require("./edit_category");
var _utils = require("../../utils");
var _custom_fields = require("./custom_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

const CaseViewActivity = ({
  ruleDetailsNavigation,
  caseData,
  actionsNavigation,
  showAlertDetails,
  useFetchAlertData
}) => {
  const [userActivityQueryParams, setUserActivityQueryParams] = (0, _react.useState)({
    type: 'all',
    sortOrder: 'asc',
    page: 1,
    perPage: 10
  });
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    caseAssignmentAuthorized,
    pushToServiceAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: caseConnectors,
    isLoading: isLoadingCaseConnectors
  } = (0, _use_get_case_connectors.useGetCaseConnectors)(caseData.id);
  const {
    data: userActionsStats,
    isLoading: isLoadingUserActionsStats
  } = (0, _use_get_case_user_actions_stats.useGetCaseUserActionsStats)(caseData.id);
  const {
    data: caseUsers,
    isLoading: isLoadingCaseUsers
  } = (0, _use_get_case_users.useGetCaseUsers)(caseData.id);
  const {
    data: casesConfiguration
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const {
    userProfiles,
    reporterAsArray
  } = (0, _utils.parseCaseUsers)({
    caseUsers,
    createdBy: caseData.createdBy
  });
  const assignees = (0, _react.useMemo)(() => caseData.assignees.map(assignee => assignee.uid), [caseData.assignees]);
  const {
    data: currentUserProfile,
    isFetching: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const onShowAlertDetails = (0, _react.useCallback)((alertId, index) => {
    if (showAlertDetails) {
      showAlertDetails(alertId, index);
    }
  }, [showAlertDetails]);
  const {
    onUpdateField,
    isLoading,
    loadingKey
  } = (0, _use_on_update_field.useOnUpdateField)({
    caseData
  });
  const isLoadingAssigneeData = isLoading && loadingKey === 'assignees' || isLoadingCaseUsers || isLoadingCurrentUserProfile;
  const changeStatus = (0, _react.useCallback)(status => onUpdateField({
    key: 'status',
    value: status
  }), [onUpdateField]);
  const onSubmitTags = (0, _react.useCallback)(newTags => onUpdateField({
    key: 'tags',
    value: newTags
  }), [onUpdateField]);
  const onSubmitCategory = (0, _react.useCallback)(newCategory => onUpdateField({
    key: 'category',
    value: newCategory
  }), [onUpdateField]);
  const onUpdateSeverity = (0, _react.useCallback)(newSeverity => onUpdateField({
    key: 'severity',
    value: newSeverity
  }), [onUpdateField]);
  const onUpdateAssignees = (0, _react.useCallback)(newAssignees => {
    const newAssigneeUids = newAssignees.map(assignee => ({
      uid: assignee.uid
    }));
    if (!(0, _lodash.isEqual)(newAssigneeUids.sort(), assignees.sort())) {
      onUpdateField({
        key: 'assignees',
        value: newAssigneeUids
      });
    }
  }, [assignees, onUpdateField]);
  const {
    isLoading: isLoadingAllAvailableConnectors,
    data: supportedActionConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const onSubmitConnector = (0, _react.useCallback)(connector => {
    onUpdateField({
      key: 'connector',
      value: connector
    });
  }, [onUpdateField]);
  const onSubmitCustomFields = (0, _react.useCallback)(customFields => {
    onUpdateField({
      key: 'customFields',
      value: customFields
    });
  }, [onUpdateField]);
  const handleUserActionsActivityChanged = (0, _react.useCallback)(params => {
    setUserActivityQueryParams(oldParams => ({
      ...oldParams,
      page: 1,
      type: params.type,
      sortOrder: params.sortOrder
    }));
  }, [setUserActivityQueryParams]);
  const showUserActions = !isLoadingUserActionsStats && !isLoadingCaseConnectors && !isLoadingCaseUsers && caseConnectors && caseUsers && userActionsStats;
  const showConnectorSidebar = pushToServiceAuthorized && caseConnectors && supportedActionConnectors;
  const isLoadingDescription = isLoading && loadingKey === 'description';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.ACTIVITY
  }), /*#__PURE__*/_react.default.createElement(_description.Description, {
    isLoadingDescription: isLoadingDescription,
    caseData: caseData,
    onUpdateField: onUpdateField
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_user_actions_activity_bar.UserActionsActivityBar, {
    onUserActionsActivityChanged: handleUserActionsActivityChanged,
    params: userActivityQueryParams,
    userActionsStats: userActionsStats,
    isLoading: isLoadingUserActionsStats
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), (isLoadingUserActionsStats || isLoadingCaseConnectors || isLoadingCaseUsers) && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "case-view-loading-content",
    size: "l"
  }), showUserActions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    "data-test-subj": "case-view-activity"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_user_actions.UserActions, {
    userProfiles: userProfiles,
    currentUserProfile: currentUserProfile,
    getRuleDetailsHref: ruleDetailsNavigation === null || ruleDetailsNavigation === void 0 ? void 0 : ruleDetailsNavigation.href,
    onRuleDetailsClick: ruleDetailsNavigation === null || ruleDetailsNavigation === void 0 ? void 0 : ruleDetailsNavigation.onClick,
    caseConnectors: caseConnectors,
    data: caseData,
    casesConfiguration: casesConfiguration,
    actionsNavigation: actionsNavigation,
    onShowAlertDetails: onShowAlertDetails,
    onUpdateField: onUpdateField,
    statusActionButton: permissions.update ? /*#__PURE__*/_react.default.createElement(_button.StatusActionButton, {
      status: caseData.status,
      onStatusChanged: changeStatus,
      isLoading: isLoading && loadingKey === 'status'
    }) : null,
    useFetchAlertData: useFetchAlertData,
    userActivityQueryParams: userActivityQueryParams,
    userActionsStats: userActionsStats
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    "data-test-subj": "case-view-page-sidebar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "xl"
  }, caseAssignmentAuthorized ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_assign_users.AssignUsers, {
    caseAssignees: caseData.assignees,
    currentUserProfile: currentUserProfile,
    onAssigneesChanged: onUpdateAssignees,
    isLoading: isLoadingAssigneeData,
    userProfiles: userProfiles !== null && userProfiles !== void 0 ? userProfiles : new Map()
  })) : null, /*#__PURE__*/_react.default.createElement(_sidebar_selector.SeveritySidebarSelector, {
    isDisabled: !permissions.update,
    isLoading: isLoading && loadingKey === 'severity',
    selectedSeverity: caseData.severity,
    onSeverityChange: onUpdateSeverity
  }), /*#__PURE__*/_react.default.createElement(_user_list.UserList, {
    dataTestSubj: "case-view-user-list-reporter",
    theCase: caseData,
    headline: i18n.REPORTER,
    users: reporterAsArray,
    userProfiles: userProfiles
  }), caseUsers != null ? /*#__PURE__*/_react.default.createElement(_user_list.UserList, {
    dataTestSubj: "case-view-user-list-participants",
    theCase: caseData,
    headline: i18n.PARTICIPANTS,
    loading: isLoadingCaseUsers,
    users: [...caseUsers.participants, ...caseUsers.assignees],
    userProfiles: userProfiles
  }) : null, /*#__PURE__*/_react.default.createElement(_edit_tags.EditTags, {
    tags: caseData.tags,
    onSubmit: onSubmitTags,
    isLoading: isLoading && loadingKey === 'tags'
  }), /*#__PURE__*/_react.default.createElement(_edit_category.EditCategory, {
    category: caseData.category,
    onSubmit: onSubmitCategory,
    isLoading: isLoading && loadingKey === 'category'
  }), showConnectorSidebar ? /*#__PURE__*/_react.default.createElement(_edit_connector.EditConnector, {
    caseData: caseData,
    caseConnectors: caseConnectors,
    supportedActionConnectors: supportedActionConnectors,
    isLoading: isLoadingAllAvailableConnectors || isLoading && loadingKey === 'connector',
    onSubmit: onSubmitConnector,
    key: caseData.connector.id
  }) : null, /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
    isLoading: isLoading && loadingKey === 'customFields',
    customFields: caseData.customFields,
    customFieldsConfiguration: casesConfiguration.customFields,
    onSubmit: onSubmitCustomFields
  }))));
};
exports.CaseViewActivity = CaseViewActivity;
CaseViewActivity.displayName = 'CaseViewActivity';