"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../common/types");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _case_action_bar = require("../case_action_bar");
var _header_page = require("../header_page");
var _editable_title = require("../header_page/editable_title");
var _use_timeline_context = require("../timeline_context/use_timeline_context");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _case_view_activity = require("./components/case_view_activity");
var _case_view_alerts = require("./components/case_view_alerts");
var _case_view_files = require("./components/case_view_files");
var _metrics = require("./metrics");
var _use_on_refresh_case_view_page = require("./use_on_refresh_case_view_page");
var _use_on_update_field = require("./use_on_update_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseViewPage = /*#__PURE__*/_react.default.memo(({
  caseData,
  onComponentInitialized,
  refreshRef,
  ruleDetailsNavigation,
  actionsNavigation,
  showAlertDetails,
  useFetchAlertData
}) => {
  var _useTimelineContext;
  const {
    features
  } = (0, _use_cases_context.useCasesContext)();
  const {
    urlParams
  } = (0, _navigation.useUrlParams)();
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  (0, _use_breadcrumbs.useCasesTitleBreadcrumbs)(caseData.title);
  const activeTabId = (0, _react.useMemo)(() => {
    if (urlParams.tabId && Object.values(_types.CASE_VIEW_PAGE_TABS).includes(urlParams.tabId)) {
      return urlParams.tabId;
    }
    return _types.CASE_VIEW_PAGE_TABS.ACTIVITY;
  }, [urlParams.tabId]);
  const init = (0, _react.useRef)(true);
  const timelineUi = (_useTimelineContext = (0, _use_timeline_context.useTimelineContext)()) === null || _useTimelineContext === void 0 ? void 0 : _useTimelineContext.ui;
  const {
    onUpdateField,
    isLoading,
    loadingKey
  } = (0, _use_on_update_field.useOnUpdateField)({
    caseData
  });

  // Set `refreshRef` if needed
  (0, _react.useEffect)(() => {
    let isStale = false;
    if (refreshRef) {
      refreshRef.current = {
        refreshCase: async () => {
          // Do nothing if component (or instance of this render cycle) is stale or it is already loading
          if (isStale || isLoading) {
            return;
          }
          refreshCaseViewPage();
        }
      };
      return () => {
        isStale = true;
        refreshRef.current = null;
      };
    }
  }, [isLoading, refreshRef, refreshCaseViewPage]);
  const onSubmitTitle = (0, _react.useCallback)(newTitle => onUpdateField({
    key: 'title',
    value: newTitle
  }), [onUpdateField]);

  // useEffect used for component's initialization
  (0, _react.useEffect)(() => {
    if (init.current) {
      init.current = false;
      if (onComponentInitialized) {
        onComponentInitialized();
      }
    }
  }, [onComponentInitialized]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: false,
    showBackButton: true,
    "data-test-subj": "case-view-title",
    titleNode: /*#__PURE__*/_react.default.createElement(_editable_title.EditableTitle, {
      isLoading: isLoading && loadingKey === 'title',
      title: caseData.title,
      onSubmit: onSubmitTitle
    }),
    title: caseData.title
  }, /*#__PURE__*/_react.default.createElement(_case_action_bar.CaseActionBar, {
    caseData: caseData,
    isLoading: isLoading && (loadingKey === 'status' || loadingKey === 'settings'),
    onUpdateField: onUpdateField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_metrics.CaseViewMetrics, {
    "data-test-subj": "case-view-metrics",
    caseId: caseData.id
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `case-view-tab-content-${activeTabId}`,
    alignItems: "baseline"
  }, activeTabId === _types.CASE_VIEW_PAGE_TABS.ACTIVITY && /*#__PURE__*/_react.default.createElement(_case_view_activity.CaseViewActivity, {
    ruleDetailsNavigation: ruleDetailsNavigation,
    caseData: caseData,
    actionsNavigation: actionsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.ALERTS && features.alerts.enabled && /*#__PURE__*/_react.default.createElement(_case_view_alerts.CaseViewAlerts, {
    caseData: caseData
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.FILES && /*#__PURE__*/_react.default.createElement(_case_view_files.CaseViewFiles, {
    caseData: caseData
  })), timelineUi !== null && timelineUi !== void 0 && timelineUi.renderTimelineDetailsPanel ? timelineUi.renderTimelineDetailsPanel() : null);
});
exports.CaseViewPage = CaseViewPage;
CaseViewPage.displayName = 'CaseViewPage';