"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTableFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _more_filters_selectable = require("./table_filter_config/more_filters_selectable");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_tags = require("../../containers/use_get_tags");
var _use_get_categories = require("../../containers/use_get_categories");
var _use_cases_features = require("../../common/use_cases_features");
var _use_system_filter_config = require("./table_filter_config/use_system_filter_config");
var _use_filter_config = require("./table_filter_config/use_filter_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeCustomizer = (objValue, srcValue, key) => {
  if (Array.isArray(objValue)) {
    return srcValue;
  }
};
const CasesTableFiltersComponent = ({
  countClosedCases,
  countOpenCases,
  countInProgressCases,
  onFilterChanged,
  hiddenStatuses,
  availableSolutions,
  isSelectorView = false,
  onCreateCasePressed,
  isLoading,
  currentUserProfile,
  filterOptions
}) => {
  const [search, setSearch] = (0, _react.useState)(filterOptions.search);
  const {
    data: tags = []
  } = (0, _use_get_tags.useGetTags)();
  const {
    data: categories = []
  } = (0, _use_get_categories.useGetCategories)();
  const {
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const onFilterOptionsChange = (0, _react.useCallback)(partialFilterOptions => {
    const newFilterOptions = (0, _lodash.mergeWith)({}, filterOptions, partialFilterOptions, mergeCustomizer);
    if (!(0, _lodash.isEqual)(newFilterOptions, filterOptions)) {
      onFilterChanged(newFilterOptions);
    }
  }, [filterOptions, onFilterChanged]);
  const {
    systemFilterConfig
  } = (0, _use_system_filter_config.useSystemFilterConfig)({
    availableSolutions,
    caseAssignmentAuthorized,
    categories,
    countClosedCases,
    countInProgressCases,
    countOpenCases,
    currentUserProfile,
    hiddenStatuses,
    isLoading,
    isSelectorView,
    onFilterOptionsChange,
    tags
  });
  const {
    filters: activeFilters,
    selectableOptions,
    activeSelectableOptionKeys,
    onFilterConfigChange
  } = (0, _use_filter_config.useFilterConfig)({
    systemFilterConfig,
    onFilterOptionsChange,
    isSelectorView,
    filterOptions
  });
  const handleOnSearch = (0, _react.useCallback)(newSearch => {
    const trimSearch = newSearch.trim();
    if (!(0, _lodash.isEqual)(trimSearch, search)) {
      setSearch(trimSearch);
      onFilterChanged({
        search: trimSearch
      });
    }
  }, [onFilterChanged, search]);
  const handleOnCreateCasePressed = (0, _react.useCallback)(() => {
    if (onCreateCasePressed) {
      onCreateCasePressed();
    }
  }, [onCreateCasePressed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    wrap: true,
    "data-test-subj": "cases-table-filters"
  }, isSelectorView && onCreateCasePressed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleOnCreateCasePressed,
    iconType: "plusInCircle",
    "data-test-subj": "cases-table-add-case-filter-bar"
  }, i18n.CREATE_CASE_TITLE)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": i18n.SEARCH_CASES,
    "data-test-subj": "search-cases",
    fullWidth: true,
    incremental: false,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    onSearch: handleOnSearch
  })), activeFilters.map(filter => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: filter.key
  }, filter.render({
    filterOptions
  }))), isSelectorView || /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_more_filters_selectable.MoreFiltersSelectable, {
    options: selectableOptions,
    activeFilters: activeSelectableOptionKeys,
    onChange: onFilterConfigChange
  })));
};
CasesTableFiltersComponent.displayName = 'CasesTableFiltersComponent';
const CasesTableFilters = /*#__PURE__*/_react.default.memo(CasesTableFiltersComponent);
exports.CasesTableFilters = CasesTableFilters;
CasesTableFilters.displayName = 'CasesTableFilters';