"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSystemFilterConfig = exports.getSystemFilterConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
var _multi_select_filter = require("../multi_select_filter");
var _solution_filter = require("../solution_filter");
var _status_filter = require("../status_filter");
var i18n = _interopRequireWildcard(require("../translations"));
var _severity_filter = require("../severity_filter");
var _assignees_filter = require("../assignees_filter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSystemFilterConfig = ({
  availableSolutions,
  caseAssignmentAuthorized,
  categories,
  countClosedCases,
  countInProgressCases,
  countOpenCases,
  currentUserProfile,
  hiddenStatuses,
  isLoading,
  isSelectorView,
  onFilterOptionsChange,
  tags
}) => {
  const onSystemFilterChange = ({
    filterId,
    selectedOptionKeys
  }) => {
    onFilterOptionsChange({
      [filterId]: selectedOptionKeys
    });
  };
  return [{
    key: 'severity',
    label: i18n.SEVERITY,
    isActive: true,
    isAvailable: true,
    getEmptyOptions: () => {
      return {
        severity: []
      };
    },
    render: ({
      filterOptions
    }) => /*#__PURE__*/_react.default.createElement(_severity_filter.SeverityFilter, {
      selectedOptionKeys: filterOptions.severity,
      onChange: onSystemFilterChange
    })
  }, {
    key: 'status',
    label: i18n.STATUS,
    isActive: true,
    isAvailable: true,
    getEmptyOptions: () => {
      return {
        status: []
      };
    },
    render: ({
      filterOptions
    }) => /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
      selectedOptionKeys: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.status,
      onChange: onSystemFilterChange,
      hiddenStatuses: hiddenStatuses,
      countClosedCases: countClosedCases,
      countInProgressCases: countInProgressCases,
      countOpenCases: countOpenCases
    })
  }, {
    key: 'assignees',
    label: i18n.ASSIGNEES,
    isActive: true,
    isAvailable: caseAssignmentAuthorized && !isSelectorView,
    getEmptyOptions: () => {
      return {
        assignees: []
      };
    },
    render: ({
      filterOptions
    }) => {
      return /*#__PURE__*/_react.default.createElement(_assignees_filter.AssigneesFilterPopover, {
        selectedAssignees: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.assignees,
        currentUserProfile: currentUserProfile,
        isLoading: isLoading,
        onSelectionChange: onSystemFilterChange
      });
    }
  }, {
    key: 'tags',
    label: i18n.TAGS,
    isActive: true,
    isAvailable: true,
    getEmptyOptions: () => {
      return {
        tags: []
      };
    },
    render: ({
      filterOptions
    }) => /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
      buttonLabel: i18n.TAGS,
      id: 'tags',
      limit: _constants.MAX_TAGS_FILTER_LENGTH,
      limitReachedMessage: i18n.MAX_SELECTED_FILTER(_constants.MAX_TAGS_FILTER_LENGTH, 'tags'),
      onChange: onSystemFilterChange,
      options: (0, _multi_select_filter.mapToMultiSelectOption)(tags),
      selectedOptionKeys: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.tags
    })
  }, {
    key: 'category',
    label: i18n.CATEGORIES,
    isActive: true,
    isAvailable: true,
    getEmptyOptions: () => {
      return {
        category: []
      };
    },
    render: ({
      filterOptions
    }) => /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
      buttonLabel: i18n.CATEGORIES,
      id: 'category',
      limit: _constants.MAX_CATEGORY_FILTER_LENGTH,
      limitReachedMessage: i18n.MAX_SELECTED_FILTER(_constants.MAX_CATEGORY_FILTER_LENGTH, 'categories'),
      onChange: onSystemFilterChange,
      options: (0, _multi_select_filter.mapToMultiSelectOption)(categories),
      selectedOptionKeys: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.category
    })
  }, {
    key: 'owner',
    label: i18n.SOLUTION,
    isActive: true,
    isAvailable: availableSolutions.length > 1,
    getEmptyOptions: () => {
      return {
        owner: []
      };
    },
    render: ({
      filterOptions
    }) => /*#__PURE__*/_react.default.createElement(_solution_filter.SolutionFilter, {
      onChange: onSystemFilterChange,
      selectedOptionKeys: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.owner,
      availableSolutions: availableSolutions
    })
  }];
};
exports.getSystemFilterConfig = getSystemFilterConfig;
const useSystemFilterConfig = ({
  availableSolutions,
  caseAssignmentAuthorized,
  categories,
  countClosedCases,
  countInProgressCases,
  countOpenCases,
  currentUserProfile,
  hiddenStatuses,
  isLoading,
  isSelectorView,
  onFilterOptionsChange,
  tags
}) => {
  const filterConfig = getSystemFilterConfig({
    availableSolutions,
    caseAssignmentAuthorized,
    categories,
    countClosedCases,
    countInProgressCases,
    countOpenCases,
    currentUserProfile,
    hiddenStatuses,
    isLoading,
    isSelectorView,
    onFilterOptionsChange,
    tags
  });
  return {
    systemFilterConfig: filterConfig
  };
};
exports.useSystemFilterConfig = useSystemFilterConfig;