"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterConfig = void 0;
var _usePrevious2 = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _lodash = require("lodash");
var _constants = require("../../../../common/constants");
var _use_custom_fields_filter_config = require("./use_custom_fields_filter_config");
var _use_cases_context = require("../../cases_context/use_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeSystemAndCustomFieldConfigs = ({
  systemFilterConfig,
  customFieldsFilterConfig
}) => {
  const newFilterConfig = new Map([...systemFilterConfig, ...customFieldsFilterConfig].filter(filter => filter.isAvailable).map(filter => [filter.key, filter]));
  return newFilterConfig;
};
const shouldBeActive = ({
  filter,
  filterOptions
}) => {
  return !filter.isActive && !(0, _lodash.isEmpty)(filterOptions[filter.key]);
};
const useActiveByFilterKeyState = ({
  filterOptions
}) => {
  const {
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const [activeByFilterKey, setActiveByFilterKey] = (0, _useLocalStorage.default)(`${appId}.${_constants.LOCAL_STORAGE_KEYS.casesTableFiltersConfig}`, []);

  /**
   * Activates filters that aren't active but have a value in the filterOptions
   */
  const newActiveByFilterKey = [...(activeByFilterKey || [])];
  newActiveByFilterKey.forEach(filter => {
    if (shouldBeActive({
      filter,
      filterOptions
    })) {
      const currentIndex = newActiveByFilterKey.findIndex(_filter => filter.key === _filter.key);
      newActiveByFilterKey.splice(currentIndex, 1);
      newActiveByFilterKey.push({
        key: filter.key,
        isActive: true
      });
    }
  });
  if (!(0, _lodash.isEqual)(newActiveByFilterKey, activeByFilterKey)) {
    setActiveByFilterKey(newActiveByFilterKey);
  }
  return [newActiveByFilterKey, setActiveByFilterKey];
};
const deactivateNonExistingFilters = ({
  prevFilterConfigs,
  currentFilterConfigs,
  onFilterOptionsChange
}) => {
  var _prevFilterConfigs$en;
  const emptyOptions = [];
  [...((_prevFilterConfigs$en = prevFilterConfigs === null || prevFilterConfigs === void 0 ? void 0 : prevFilterConfigs.entries()) !== null && _prevFilterConfigs$en !== void 0 ? _prevFilterConfigs$en : [])].forEach(([filterKey, filter]) => {
    if (!currentFilterConfigs.has(filterKey)) {
      emptyOptions.push(filter.getEmptyOptions());
    }
  });
  if (emptyOptions.length > 0) {
    const mergedEmptyOptions = (0, _lodash.merge)({}, ...emptyOptions);
    onFilterOptionsChange(mergedEmptyOptions);
  }
};
const useFilterConfig = ({
  isSelectorView,
  onFilterOptionsChange,
  systemFilterConfig,
  filterOptions
}) => {
  var _usePrevious;
  /**
   * Initially we won't save any order, it will use the default config as it is defined in the system.
   * Once the user adds/removes a filter, we start saving the order and the visible state.
   */
  const [activeByFilterKey, setActiveByFilterKey] = useActiveByFilterKeyState({
    filterOptions
  });
  const {
    customFieldsFilterConfig
  } = (0, _use_custom_fields_filter_config.useCustomFieldsFilterConfig)({
    isSelectorView,
    onFilterOptionsChange
  });
  const filterConfigs = mergeSystemAndCustomFieldConfigs({
    systemFilterConfig,
    customFieldsFilterConfig
  });
  const prevFilterConfigs = (_usePrevious = (0, _usePrevious2.default)(filterConfigs)) !== null && _usePrevious !== void 0 ? _usePrevious : new Map();
  deactivateNonExistingFilters({
    prevFilterConfigs,
    currentFilterConfigs: filterConfigs,
    onFilterOptionsChange
  });
  const onChange = ({
    selectedOptionKeys
  }) => {
    const newActiveByFilterKey = [...(activeByFilterKey || [])];
    const deactivatedFilters = [];

    // for each filter in the current state, this way we keep the order
    (activeByFilterKey || []).forEach(({
      key,
      isActive: prevIsActive
    }) => {
      const currentIndex = newActiveByFilterKey.findIndex(filter => filter.key === key);
      if (filterConfigs.has(key)) {
        const isActive = selectedOptionKeys.find(optionKey => optionKey === key);
        if (isActive && !prevIsActive) {
          // remove/insert to the end with isActive = true
          newActiveByFilterKey.splice(currentIndex, 1);
          newActiveByFilterKey.push({
            key,
            isActive: true
          });
        } else if (!isActive && prevIsActive) {
          // dont move, just update isActive = false
          deactivatedFilters.push(key);
          newActiveByFilterKey[currentIndex] = {
            key,
            isActive: false
          };
        }
      } else {
        // we might have in local storage a key of a field that don't exist anymore
        newActiveByFilterKey.splice(currentIndex, 1);
      }
    });

    // for each filter in the config
    filterConfigs.forEach(({
      key: configKey
    }) => {
      // add it if its a new filter
      if (!newActiveByFilterKey.find(({
        key
      }) => key === configKey)) {
        // first time, the current state is empty, all filters will be added
        // isActive = true if the filter is in the selectedOptionKeys
        const isActive = selectedOptionKeys.find(optionKey => optionKey === configKey);
        if (!isActive) {
          // for system filter that is removed as first action
          deactivatedFilters.push(configKey);
        }
        newActiveByFilterKey.push({
          key: configKey,
          isActive: Boolean(isActive)
        });
      }
    });
    const emptyOptions = deactivatedFilters.filter(key => filterConfigs.has(key)).map(key => filterConfigs.get(key).getEmptyOptions());
    if (emptyOptions.length > 0) {
      const mergedEmptyOptions = (0, _lodash.merge)({}, ...emptyOptions);
      onFilterOptionsChange(mergedEmptyOptions);
    }
    setActiveByFilterKey(newActiveByFilterKey);
  };
  const filterConfigArray = Array.from(filterConfigs.values());
  const selectableOptions = filterConfigArray.map(({
    key,
    label
  }) => ({
    key,
    label
  })).sort((a, b) => {
    if (a.label > b.label) return 1;
    if (a.label < b.label) return -1;
    return a.key > b.key ? 1 : -1;
  });
  const source = activeByFilterKey && activeByFilterKey.length > 0 ? activeByFilterKey : filterConfigArray;
  const activeFilters = source.filter(filter => filter.isActive && filterConfigs.has(filter.key)).map(filter => filterConfigs.get(filter.key));
  const activeFilterKeys = activeFilters.map(filter => filter.key);
  return {
    activeSelectableOptionKeys: activeFilterKeys,
    filters: activeFilters,
    onFilterConfigChange: onChange,
    selectableOptions
  };
};
exports.useFilterConfig = useFilterConfig;