"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesAddToExistingCaseModal = void 0;
var _react = require("react");
var _domain = require("../../../../common/types/domain");
var _use_cases_toast = require("../../../common/use_cases_toast");
var _cases_context_reducer = require("../../cases_context/cases_context_reducer");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _use_cases_add_to_new_case_flyout = require("../../create/flyout/use_cases_add_to_new_case_flyout");
var _use_create_attachments = require("../../../containers/use_create_attachments");
var _use_cases_transactions = require("../../../common/apm/use_cases_transactions");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesAddToExistingCaseModal = (props = {}) => {
  var _props$successToaster, _props$successToaster2;
  const createNewCaseFlyout = (0, _use_cases_add_to_new_case_flyout.useCasesAddToNewCaseFlyout)({
    onClose: props.onClose,
    onSuccess: theCase => {
      if (props.onSuccess && theCase) {
        return props.onSuccess(theCase);
      }
    },
    toastTitle: (_props$successToaster = props.successToaster) === null || _props$successToaster === void 0 ? void 0 : _props$successToaster.title,
    toastContent: (_props$successToaster2 = props.successToaster) === null || _props$successToaster2 === void 0 ? void 0 : _props$successToaster2.content
  });
  const {
    dispatch,
    appId
  } = (0, _use_cases_context.useCasesContext)();
  const casesToasts = (0, _use_cases_toast.useCasesToast)();
  const {
    mutateAsync: createAttachments
  } = (0, _use_create_attachments.useCreateAttachments)();
  const {
    startTransaction
  } = (0, _use_cases_transactions.useAddAttachmentToExistingCaseTransaction)();
  const closeModal = (0, _react.useCallback)(() => {
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.CLOSE_ADD_TO_CASE_MODAL
    });
    // in case the flyout was also open when selecting
    // create a new case
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.CLOSE_CREATE_CASE_FLYOUT
    });
  }, [dispatch]);
  const handleOnRowClick = (0, _react.useCallback)(async (theCase, getAttachments) => {
    var _getAttachments;
    const attachments = (_getAttachments = getAttachments === null || getAttachments === void 0 ? void 0 : getAttachments({
      theCase
    })) !== null && _getAttachments !== void 0 ? _getAttachments : [];

    // when the case is undefined in the modal
    // the user clicked "create new case"
    if (theCase === undefined) {
      closeModal();
      createNewCaseFlyout.open({
        attachments
      });
      return;
    }
    try {
      var _props$successToaster3, _props$successToaster4;
      // add attachments to the case
      if (attachments === undefined || attachments.length === 0) {
        var _props$noAttachmentsT, _props$noAttachmentsT2, _props$noAttachmentsT3;
        const title = (_props$noAttachmentsT = (_props$noAttachmentsT2 = props.noAttachmentsToaster) === null || _props$noAttachmentsT2 === void 0 ? void 0 : _props$noAttachmentsT2.title) !== null && _props$noAttachmentsT !== void 0 ? _props$noAttachmentsT : _translations.NO_ATTACHMENTS_ADDED;
        const content = (_props$noAttachmentsT3 = props.noAttachmentsToaster) === null || _props$noAttachmentsT3 === void 0 ? void 0 : _props$noAttachmentsT3.content;
        casesToasts.showInfoToast(title, content);
        return;
      }
      startTransaction({
        appId,
        attachments
      });
      await createAttachments({
        caseId: theCase.id,
        caseOwner: theCase.owner,
        attachments
      });
      if (props.onSuccess) {
        props.onSuccess(theCase);
      }
      casesToasts.showSuccessAttach({
        theCase,
        attachments,
        title: (_props$successToaster3 = props.successToaster) === null || _props$successToaster3 === void 0 ? void 0 : _props$successToaster3.title,
        content: (_props$successToaster4 = props.successToaster) === null || _props$successToaster4 === void 0 ? void 0 : _props$successToaster4.content
      });
    } catch (error) {
      // error toast is handled
      // inside the createAttachments method
    }
  }, [appId, casesToasts, closeModal, createAttachments, createNewCaseFlyout, props, startTransaction]);
  const openModal = (0, _react.useCallback)(({
    getAttachments
  } = {}) => {
    dispatch({
      type: _cases_context_reducer.CasesContextStoreActionsList.OPEN_ADD_TO_CASE_MODAL,
      payload: {
        ...props,
        hiddenStatuses: [_domain.CaseStatuses.closed],
        onRowClick: theCase => {
          handleOnRowClick(theCase, getAttachments);
        },
        onClose: (theCase, isCreateCase) => {
          closeModal();
          if (props.onClose) {
            return props.onClose(theCase, isCreateCase);
          }
        }
      }
    });
  }, [closeModal, dispatch, handleOnRowClick, props]);
  return {
    open: openModal,
    close: closeModal
  };
};
exports.useCasesAddToExistingCaseModal = useCasesAddToExistingCaseModal;