"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToMultiSelectOption = exports.MultiSelectFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapToMultiSelectOption = options => {
  return options.map(option => {
    return {
      key: option,
      label: option
    };
  });
};
exports.mapToMultiSelectOption = mapToMultiSelectOption;
const fromRawOptionsToEuiSelectableOptions = (options, selectedOptionKeys) => {
  return options.map(({
    key,
    label
  }) => {
    const selectableOption = {
      label,
      key
    };
    if (selectedOptionKeys.includes(key)) {
      selectableOption.checked = 'on';
    }
    selectableOption['data-test-subj'] = `options-filter-popover-item-${key.split(' ').join('-')}`;
    return selectableOption;
  });
};
const fromEuiSelectableOptionToRawOption = options => {
  return options.map(option => option.key);
};
const getEuiSelectableCheckedOptions = options => options.filter(option => option.checked === 'on');
const MultiSelectFilter = ({
  buttonLabel,
  buttonIconType,
  hideActiveOptionsNumber,
  id,
  limit,
  limitReachedMessage,
  onChange,
  options: rawOptions,
  selectedOptionKeys = [],
  renderOption,
  transparentBackground
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const toggleIsPopoverOpen = () => setIsPopoverOpen(prevValue => !prevValue);
  const showActiveOptionsNumber = !hideActiveOptionsNumber;
  const isInvalid = Boolean(limit && limitReachedMessage && selectedOptionKeys.length >= limit);
  const options = fromRawOptionsToEuiSelectableOptions(rawOptions, selectedOptionKeys);
  (0, _react.useEffect)(() => {
    const newSelectedOptions = selectedOptionKeys.filter(selectedOptionKey => rawOptions.some(({
      key: optionKey
    }) => optionKey === selectedOptionKey));
    if (!(0, _fp.isEqual)(newSelectedOptions, selectedOptionKeys)) {
      onChange({
        filterId: id,
        selectedOptionKeys: newSelectedOptions
      });
    }
  }, [selectedOptionKeys, rawOptions, id, onChange]);
  const _onChange = newOptions => {
    const newSelectedOptions = getEuiSelectableCheckedOptions(newOptions);
    if (isInvalid && limit && newSelectedOptions.length >= limit) {
      return;
    }
    onChange({
      filterId: id,
      selectedOptionKeys: fromEuiSelectableOptionToRawOption(newSelectedOptions)
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    css: (0, _react2.css)`
        ${transparentBackground && 'background-color: transparent;'};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      css: (0, _react2.css)`
              max-width: 186px;
            `,
      "data-test-subj": `options-filter-popover-button-${id}`,
      iconType: buttonIconType || 'arrowDown',
      onClick: toggleIsPopoverOpen,
      isSelected: isPopoverOpen,
      numFilters: showActiveOptionsNumber ? options.length : undefined,
      hasActiveFilters: showActiveOptionsNumber ? selectedOptionKeys.length > 0 : undefined,
      numActiveFilters: showActiveOptionsNumber ? selectedOptionKeys.length : undefined,
      "aria-label": buttonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textTruncate"
    }, buttonLabel)),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, isInvalid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: limitReachedMessage,
    color: "warning",
    size: "s",
    "data-test-subj": "maximum-length-warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    searchable: true,
    searchProps: {
      placeholder: buttonLabel,
      compressed: false,
      'data-test-subj': `${id}-search-input`
    },
    emptyMessage: i18n.EMPTY_FILTER_MESSAGE,
    onChange: _onChange,
    singleSelection: false,
    renderOption: renderOption
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                width: 400px;
              `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                  line-height: ${euiTheme.size.xl};
                  padding-left: ${euiTheme.size.m};
                  border-bottom: ${euiTheme.border.thin};
                `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.OPTIONS(options.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), list))));
};
exports.MultiSelectFilter = MultiSelectFilter;
MultiSelectFilter.displayName = 'MultiSelectFilter';