"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseUserActionWithoutConnectorIdRt = exports.CreateCaseUserActionRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _v = require("../action/v1");
var _v2 = require("../assignees/v1");
var _v3 = require("../category/v1");
var _v4 = require("../connector/v1");
var _v5 = require("../custom_fields/v1");
var _v6 = require("../description/v1");
var _v7 = require("../settings/v1");
var _v8 = require("../tags/v1");
var _v9 = require("../title/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonFieldsRt = rt.strict({
  type: rt.literal(_v.UserActionTypes.create_case)
});
const CommonPayloadAttributesRt = rt.strict({
  assignees: _v2.AssigneesUserActionPayloadRt.type.props.assignees,
  description: _v6.DescriptionUserActionPayloadRt.type.props.description,
  status: rt.string,
  severity: rt.string,
  tags: _v8.TagsUserActionPayloadRt.type.props.tags,
  title: _v9.TitleUserActionPayloadRt.type.props.title,
  settings: _v7.SettingsUserActionPayloadRt.type.props.settings,
  owner: rt.string
});
const OptionalPayloadAttributesRt = rt.exact(rt.partial({
  category: _v3.CategoryUserActionPayloadRt.type.props.category,
  customFields: _v5.CustomFieldsUserActionPayloadRt.type.props.customFields
}));
const PayloadAttributesRt = rt.intersection([CommonPayloadAttributesRt, OptionalPayloadAttributesRt]);
const CreateCaseUserActionRt = rt.intersection([CommonFieldsRt, rt.strict({
  payload: rt.intersection([_v4.ConnectorUserActionPayloadRt, PayloadAttributesRt])
})]);
exports.CreateCaseUserActionRt = CreateCaseUserActionRt;
const CreateCaseUserActionWithoutConnectorIdRt = rt.intersection([CommonFieldsRt, rt.strict({
  payload: rt.intersection([_v4.ConnectorUserActionPayloadWithoutConnectorIdRt, PayloadAttributesRt])
})]);
exports.CreateCaseUserActionWithoutConnectorIdRt = CreateCaseUserActionWithoutConnectorIdRt;