"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersRt = exports.UserWithProfileInfoRt = exports.UserRt = exports.CaseUserProfileRt = exports.CaseAssigneesRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserWithoutProfileUidRt = rt.strict({
  email: rt.union([rt.undefined, rt.null, rt.string]),
  full_name: rt.union([rt.undefined, rt.null, rt.string]),
  username: rt.union([rt.undefined, rt.null, rt.string])
});
const UserRt = rt.intersection([UserWithoutProfileUidRt, rt.exact(rt.partial({
  profile_uid: rt.string
}))]);
exports.UserRt = UserRt;
const UserWithProfileInfoRt = rt.intersection([rt.strict({
  user: UserWithoutProfileUidRt
}), rt.exact(rt.partial({
  uid: rt.string
})), rt.exact(rt.partial({
  avatar: rt.exact(rt.partial({
    initials: rt.union([rt.string, rt.null]),
    color: rt.union([rt.string, rt.null]),
    imageUrl: rt.union([rt.string, rt.null])
  }))
}))]);
exports.UserWithProfileInfoRt = UserWithProfileInfoRt;
const UsersRt = rt.array(UserRt);
exports.UsersRt = UsersRt;
const CaseUserProfileRt = rt.strict({
  uid: rt.string
});
exports.CaseUserProfileRt = CaseUserProfileRt;
/**
 * Assignees
 */
const CaseAssigneesRt = rt.array(CaseUserProfileRt);
exports.CaseAssigneesRt = CaseAssigneesRt;