"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetTagsResponseRt = exports.GetReportersResponseRt = exports.GetRelatedCasesByAlertResponseRt = exports.GetCategoriesResponseRt = exports.CasesSearchRequestRt = exports.CasesPatchRequestRt = exports.CasesFindResponseRt = exports.CasesFindRequestSortFieldsRt = exports.CasesFindRequestSearchFieldsRt = exports.CasesFindRequestRt = exports.CasesDeleteRequestRt = exports.CasesByAlertIDRequestRt = exports.CasesBulkGetResponseRt = exports.CasesBulkGetRequestRt = exports.CaseResolveResponseRt = exports.CasePushRequestParamsRt = exports.CasePostRequestRt = exports.CasePatchRequestRt = exports.BulkCreateCasesResponseRt = exports.BulkCreateCasesRequestRt = exports.AllTagsFindRequestRt = exports.AllReportersFindRequestRt = exports.AllCategoriesFindRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _domain = require("../../domain");
var _v = require("../../domain/case/v1");
var _v2 = require("../../domain/connector/v1");
var _v3 = require("../../domain/user/v1");
var _v4 = require("../stats/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseCustomFieldTextWithValidationValueRt = (0, _schema.limitedStringSchema)({
  fieldName: 'value',
  min: 1,
  max: _constants.MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH
});
const CaseCustomFieldTextWithValidationRt = rt.strict({
  key: rt.string,
  type: _domain.CustomFieldTextTypeRt,
  value: rt.union([CaseCustomFieldTextWithValidationValueRt, rt.null])
});
const CustomFieldRt = rt.union([CaseCustomFieldTextWithValidationRt, _domain.CaseCustomFieldToggleRt]);
const CustomFieldsRt = (0, _schema.limitedArraySchema)({
  codec: CustomFieldRt,
  fieldName: 'customFields',
  min: 0,
  max: _constants.MAX_CUSTOM_FIELDS_PER_CASE
});

/**
 * Create case
 */
const CasePostRequestRt = rt.intersection([rt.strict({
  /**
   * Description of the case
   */
  description: (0, _schema.limitedStringSchema)({
    fieldName: 'description',
    min: 1,
    max: _constants.MAX_DESCRIPTION_LENGTH
  }),
  /**
   * Identifiers for the case.
   */
  tags: (0, _schema.limitedArraySchema)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'tag',
      min: 1,
      max: _constants.MAX_LENGTH_PER_TAG
    }),
    fieldName: 'tags',
    min: 0,
    max: _constants.MAX_TAGS_PER_CASE
  }),
  /**
   * Title of the case
   */
  title: (0, _schema.limitedStringSchema)({
    fieldName: 'title',
    min: 1,
    max: _constants.MAX_TITLE_LENGTH
  }),
  /**
   * The external configuration for the case
   */
  connector: _v2.CaseConnectorRt,
  /**
   * Sync settings for alerts
   */
  settings: _v.CaseSettingsRt,
  /**
   * The owner here must match the string used when a plugin registers a feature with access to the cases plugin. The user
   * creating this case must also be granted access to that plugin's feature.
   */
  owner: rt.string
}), rt.exact(rt.partial({
  /**
   * The users assigned to the case
   */
  assignees: (0, _schema.limitedArraySchema)({
    codec: _v3.CaseUserProfileRt,
    fieldName: 'assignees',
    min: 0,
    max: _constants.MAX_ASSIGNEES_PER_CASE
  }),
  /**
   * The severity of the case. The severity is
   * default it to "low" if not provided.
   */
  severity: _v.CaseSeverityRt,
  /**
   * The category of the case.
   */
  category: rt.union([(0, _schema.limitedStringSchema)({
    fieldName: 'category',
    min: 1,
    max: _constants.MAX_CATEGORY_LENGTH
  }), rt.null]),
  /**
   * The list of custom field values of the case.
   */
  customFields: CustomFieldsRt
}))]);

/**
 * Bulk create cases
 */
exports.CasePostRequestRt = CasePostRequestRt;
const CaseCreateRequestWithOptionalId = rt.intersection([CasePostRequestRt, rt.exact(rt.partial({
  id: rt.string
}))]);
const BulkCreateCasesRequestRt = rt.strict({
  cases: rt.array(CaseCreateRequestWithOptionalId)
});
exports.BulkCreateCasesRequestRt = BulkCreateCasesRequestRt;
const BulkCreateCasesResponseRt = rt.strict({
  cases: rt.array(_v.CaseRt)
});

/**
 * Find cases
 */
exports.BulkCreateCasesResponseRt = BulkCreateCasesResponseRt;
const CasesFindRequestSearchFieldsRt = rt.keyof({
  description: null,
  title: null
});
exports.CasesFindRequestSearchFieldsRt = CasesFindRequestSearchFieldsRt;
const CasesFindRequestSortFieldsRt = rt.keyof({
  title: null,
  category: null,
  createdAt: null,
  updatedAt: null,
  closedAt: null,
  status: null,
  severity: null
});
exports.CasesFindRequestSortFieldsRt = CasesFindRequestSortFieldsRt;
const CasesFindRequestRt = rt.intersection([rt.exact(rt.partial({
  /**
   * Tags to filter by
   */
  tags: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'tags',
    min: 0,
    max: _constants.MAX_TAGS_FILTER_LENGTH
  }), rt.string]),
  /**
   * The status of the case (open, closed, in-progress)
   */
  status: rt.union([_v.CaseStatusRt, rt.array(_v.CaseStatusRt)]),
  /**
   * The severity of the case
   */
  severity: rt.union([_v.CaseSeverityRt, rt.array(_v.CaseSeverityRt)]),
  /**
   * The uids of the user profiles to filter by
   */
  assignees: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'assignees',
    min: 0,
    max: _constants.MAX_ASSIGNEES_FILTER_LENGTH
  }), rt.string]),
  /**
   * The reporters to filter by
   */
  reporters: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'reporters',
    min: 0,
    max: _constants.MAX_REPORTERS_FILTER_LENGTH
  }), rt.string]),
  /**
   * Operator to use for the `search` field
   */
  defaultSearchOperator: rt.union([rt.literal('AND'), rt.literal('OR')]),
  /**
   * A KQL date. If used all cases created after (gte) the from date will be returned
   */
  from: rt.string,
  /**
   * The page of objects to return
   */
  // page: rt.union([rt.number, NumberFromString]),
  /**
   * The number of objects to include in each page
   */
  // perPage: rt.union([rt.number, NumberFromString]),
  /**
   * An Elasticsearch simple_query_string
   */
  search: rt.string,
  /**
   * The fields to perform the simple_query_string parsed query against
   */
  searchFields: rt.union([rt.array(CasesFindRequestSearchFieldsRt), CasesFindRequestSearchFieldsRt]),
  /**
   * The field to use for sorting the found objects.
   *
   */
  sortField: CasesFindRequestSortFieldsRt,
  /**
   * The order to sort by
   */
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')]),
  /**
   * A KQL date. If used all cases created before (lte) the to date will be returned.
   */
  to: rt.string,
  /**
   * The owner(s) to filter by. The user making the request must have privileges to retrieve cases of that
   * ownership or they will be ignored. If no owner is included, then all ownership types will be included in the response
   * that the user has access to.
   */

  owner: rt.union([rt.array(rt.string), rt.string]),
  /**
   * The category of the case.
   */
  category: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'category',
    min: 0,
    max: _constants.MAX_CATEGORY_FILTER_LENGTH
  }), rt.string])
})), (0, _schema.paginationSchema)({
  maxPerPage: _constants.MAX_CASES_PER_PAGE
})]);
exports.CasesFindRequestRt = CasesFindRequestRt;
const CasesSearchRequestRt = rt.intersection([rt.exact(rt.partial({
  /**
   * custom fields of the case
   */
  customFields: rt.record(rt.string, rt.array(rt.union([rt.string, rt.boolean, rt.number, rt.null])))
})), CasesFindRequestRt]);
exports.CasesSearchRequestRt = CasesSearchRequestRt;
const CasesFindResponseRt = rt.intersection([rt.strict({
  cases: rt.array(_v.CaseRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
}), _v4.CasesStatusResponseRt]);

/**
 * Delete cases
 */
exports.CasesFindResponseRt = CasesFindResponseRt;
const CasesDeleteRequestRt = (0, _schema.limitedArraySchema)({
  codec: _schema.NonEmptyString,
  min: 1,
  max: _constants.MAX_DELETE_IDS_LENGTH,
  fieldName: 'ids'
});

/**
 * Resolve case
 */
exports.CasesDeleteRequestRt = CasesDeleteRequestRt;
const CaseResolveResponseRt = rt.intersection([rt.strict({
  case: _v.CaseRt,
  outcome: rt.union([rt.literal('exactMatch'), rt.literal('aliasMatch'), rt.literal('conflict')])
}), rt.exact(rt.partial({
  alias_target_id: rt.string,
  alias_purpose: rt.union([rt.literal('savedObjectConversion'), rt.literal('savedObjectImport')])
}))]);

/**
 * Get cases
 */
exports.CaseResolveResponseRt = CaseResolveResponseRt;
const CasesBulkGetRequestRt = rt.strict({
  ids: (0, _schema.limitedArraySchema)({
    codec: rt.string,
    min: 1,
    max: _constants.MAX_BULK_GET_CASES,
    fieldName: 'ids'
  })
});
exports.CasesBulkGetRequestRt = CasesBulkGetRequestRt;
const CasesBulkGetResponseRt = rt.strict({
  cases: _v.CasesRt,
  errors: rt.array(rt.strict({
    error: rt.string,
    message: rt.string,
    status: rt.union([rt.undefined, rt.number]),
    caseId: rt.string
  }))
});

/**
 * Update cases
 */
exports.CasesBulkGetResponseRt = CasesBulkGetResponseRt;
const CasePatchRequestRt = rt.intersection([rt.exact(rt.partial({
  /**
   * The description of the case
   */
  description: (0, _schema.limitedStringSchema)({
    fieldName: 'description',
    min: 1,
    max: _constants.MAX_DESCRIPTION_LENGTH
  }),
  /**
   * The current status of the case (open, closed, in-progress)
   */
  status: _v.CaseStatusRt,
  /**
   * The identifying strings for filter a case
   */
  tags: (0, _schema.limitedArraySchema)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'tag',
      min: 1,
      max: _constants.MAX_LENGTH_PER_TAG
    }),
    min: 0,
    max: _constants.MAX_TAGS_PER_CASE,
    fieldName: 'tags'
  }),
  /**
   * The title of a case
   */
  title: (0, _schema.limitedStringSchema)({
    fieldName: 'title',
    min: 1,
    max: _constants.MAX_TITLE_LENGTH
  }),
  /**
   * The external system that the case can be synced with
   */
  connector: _v2.CaseConnectorRt,
  /**
   * The alert sync settings
   */
  settings: _v.CaseSettingsRt,
  /**
   * The plugin owner of the case
   */
  owner: rt.string,
  /**
   * The severity of the case
   */
  severity: _v.CaseSeverityRt,
  /**
   * The users assigned to this case
   */
  assignees: (0, _schema.limitedArraySchema)({
    codec: _v3.CaseUserProfileRt,
    fieldName: 'assignees',
    min: 0,
    max: _constants.MAX_ASSIGNEES_PER_CASE
  }),
  /**
   * The category of the case.
   */
  category: rt.union([(0, _schema.limitedStringSchema)({
    fieldName: 'category',
    min: 1,
    max: _constants.MAX_CATEGORY_LENGTH
  }), rt.null]),
  /**
   * Custom fields of the case
   */
  customFields: CustomFieldsRt
})),
/**
 * The saved object ID and version
 */
rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.CasePatchRequestRt = CasePatchRequestRt;
const CasesPatchRequestRt = rt.strict({
  cases: (0, _schema.limitedArraySchema)({
    codec: CasePatchRequestRt,
    min: 1,
    max: _constants.MAX_CASES_TO_UPDATE,
    fieldName: 'cases'
  })
});

/**
 * Push case
 */
exports.CasesPatchRequestRt = CasesPatchRequestRt;
const CasePushRequestParamsRt = rt.strict({
  case_id: rt.string,
  connector_id: rt.string
});

/**
 * Taxonomies
 */
exports.CasePushRequestParamsRt = CasePushRequestParamsRt;
const AllTagsFindRequestRt = rt.exact(rt.partial({
  /**
   * The owner of the cases to retrieve the tags from. If no owner is provided the tags from all cases
   * that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
exports.AllTagsFindRequestRt = AllTagsFindRequestRt;
const AllCategoriesFindRequestRt = rt.exact(rt.partial({
  /**
   * The owner of the cases to retrieve the categories from. If no owner is provided the categories
   * from all cases that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
exports.AllCategoriesFindRequestRt = AllCategoriesFindRequestRt;
const AllReportersFindRequestRt = AllTagsFindRequestRt;
exports.AllReportersFindRequestRt = AllReportersFindRequestRt;
const GetTagsResponseRt = rt.array(rt.string);
exports.GetTagsResponseRt = GetTagsResponseRt;
const GetCategoriesResponseRt = rt.array(rt.string);
exports.GetCategoriesResponseRt = GetCategoriesResponseRt;
const GetReportersResponseRt = rt.array(_v3.UserRt);

/**
 * Alerts
 */
exports.GetReportersResponseRt = GetReportersResponseRt;
const CasesByAlertIDRequestRt = rt.exact(rt.partial({
  /**
   * The type of cases to retrieve given an alert ID. If no owner is provided, all cases
   * that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
exports.CasesByAlertIDRequestRt = CasesByAlertIDRequestRt;
const GetRelatedCasesByAlertResponseRt = rt.array(_v.RelatedCaseRt);
exports.GetRelatedCasesByAlertResponseRt = GetRelatedCasesByAlertResponseRt;