"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_SOLUTION_OWNER = exports.OWNER_INFO = exports.OWNERS = exports.OBSERVABILITY_OWNER = exports.GENERAL_CASES_OWNER = void 0;
var _application = require("./application");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Owner
 */
const SECURITY_SOLUTION_OWNER = 'securitySolution';
exports.SECURITY_SOLUTION_OWNER = SECURITY_SOLUTION_OWNER;
const OBSERVABILITY_OWNER = 'observability';
exports.OBSERVABILITY_OWNER = OBSERVABILITY_OWNER;
const GENERAL_CASES_OWNER = _application.APP_ID;
exports.GENERAL_CASES_OWNER = GENERAL_CASES_OWNER;
const OWNERS = [GENERAL_CASES_OWNER, OBSERVABILITY_OWNER, SECURITY_SOLUTION_OWNER];
exports.OWNERS = OWNERS;
const OWNER_INFO = {
  [SECURITY_SOLUTION_OWNER]: {
    id: SECURITY_SOLUTION_OWNER,
    appId: 'securitySolutionUI',
    label: 'Security',
    iconType: 'logoSecurity',
    appRoute: '/app/security'
  },
  [OBSERVABILITY_OWNER]: {
    id: OBSERVABILITY_OWNER,
    appId: 'observability-overview',
    label: 'Observability',
    iconType: 'logoObservability',
    appRoute: '/app/observability'
  },
  [GENERAL_CASES_OWNER]: {
    id: GENERAL_CASES_OWNER,
    appId: 'management',
    label: 'Stack',
    iconType: 'casesApp',
    appRoute: '/app/management/insightsAndAlerting'
  }
};
exports.OWNER_INFO = OWNER_INFO;