"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _status = require("../status/status");
var _types = require("../status/types");
var _icon_with_count = require("./icon_with_count");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TITLE_TRUNCATE_LENGTH = 35;
const DESCRIPTION_TRUNCATE_LENGTH = 80;
const USER_TRUNCATE_LENGTH = 15;
const CaseTooltipContentComponent = /*#__PURE__*/_react.default.memo(({
  title,
  description,
  status,
  totalComments,
  createdAt,
  createdBy
}) => {
  var _ref, _createdBy$username;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_status.Status, {
    status: status
  })), /*#__PURE__*/_react.default.createElement(_icon_with_count.IconWithCount, {
    count: totalComments,
    icon: 'editorComment'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative"
  }, /*#__PURE__*/_react.default.createElement("strong", null, (0, _utils.getTruncatedText)(title, TITLE_TRUNCATE_LENGTH)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative"
  }, (0, _utils.getTruncatedText)(description, DESCRIPTION_TRUNCATE_LENGTH))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative"
  }, status === _types.CaseStatuses.closed ? i18n.CLOSED : i18n.OPENED, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: createdAt
  }), ' ', createdBy.username || createdBy.fullName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.BY, ' ', /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": "tooltip-username"
  }, (0, _utils.getTruncatedText)((_ref = (_createdBy$username = createdBy.username) !== null && _createdBy$username !== void 0 ? _createdBy$username : createdBy.fullName) !== null && _ref !== void 0 ? _ref : '', USER_TRUNCATE_LENGTH))) : null));
});
CaseTooltipContentComponent.displayName = 'TooltipContent';
const TooltipContent = /*#__PURE__*/(0, _react.memo)(CaseTooltipContentComponent);
exports.TooltipContent = TooltipContent;