"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "customElementServiceFactory", {
  enumerable: true,
  get: function () {
    return _custom_element.customElementServiceFactory;
  }
});
Object.defineProperty(exports, "dataViewsServiceFactory", {
  enumerable: true,
  get: function () {
    return _data_views.dataViewsServiceFactory;
  }
});
Object.defineProperty(exports, "embeddablesServiceFactory", {
  enumerable: true,
  get: function () {
    return _embeddables.embeddablesServiceFactory;
  }
});
Object.defineProperty(exports, "expressionsServiceFactory", {
  enumerable: true,
  get: function () {
    return _expressions.expressionsServiceFactory;
  }
});
Object.defineProperty(exports, "filtersServiceFactory", {
  enumerable: true,
  get: function () {
    return _filters.filtersServiceFactory;
  }
});
Object.defineProperty(exports, "labsServiceFactory", {
  enumerable: true,
  get: function () {
    return _labs.labsServiceFactory;
  }
});
Object.defineProperty(exports, "notifyServiceFactory", {
  enumerable: true,
  get: function () {
    return _notify.notifyServiceFactory;
  }
});
Object.defineProperty(exports, "platformServiceFactory", {
  enumerable: true,
  get: function () {
    return _platform.platformServiceFactory;
  }
});
exports.pluginServiceRegistry = exports.pluginServiceProviders = void 0;
Object.defineProperty(exports, "reportingServiceFactory", {
  enumerable: true,
  get: function () {
    return _reporting.reportingServiceFactory;
  }
});
Object.defineProperty(exports, "visualizationsServiceFactory", {
  enumerable: true,
  get: function () {
    return _visualizations.visualizationsServiceFactory;
  }
});
Object.defineProperty(exports, "workpadServiceFactory", {
  enumerable: true,
  get: function () {
    return _workpad.workpadServiceFactory;
  }
});
var _public = require("@kbn/presentation-util-plugin/public");
var _custom_element = require("./custom_element");
var _data_views = require("./data_views");
var _embeddables = require("./embeddables");
var _expressions = require("./expressions");
var _labs = require("./labs");
var _nav_link = require("./nav_link");
var _notify = require("./notify");
var _platform = require("./platform");
var _reporting = require("./reporting");
var _visualizations = require("./visualizations");
var _workpad = require("./workpad");
var _filters = require("./filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pluginServiceProviders = {
  customElement: new _public.PluginServiceProvider(_custom_element.customElementServiceFactory),
  dataViews: new _public.PluginServiceProvider(_data_views.dataViewsServiceFactory, ['notify']),
  embeddables: new _public.PluginServiceProvider(_embeddables.embeddablesServiceFactory),
  expressions: new _public.PluginServiceProvider(_expressions.expressionsServiceFactory, ['filters', 'notify']),
  filters: new _public.PluginServiceProvider(_filters.filtersServiceFactory),
  labs: new _public.PluginServiceProvider(_labs.labsServiceFactory),
  navLink: new _public.PluginServiceProvider(_nav_link.navLinkServiceFactory),
  notify: new _public.PluginServiceProvider(_notify.notifyServiceFactory),
  platform: new _public.PluginServiceProvider(_platform.platformServiceFactory),
  reporting: new _public.PluginServiceProvider(_reporting.reportingServiceFactory),
  visualizations: new _public.PluginServiceProvider(_visualizations.visualizationsServiceFactory),
  workpad: new _public.PluginServiceProvider(_workpad.workpadServiceFactory)
};
exports.pluginServiceProviders = pluginServiceProviders;
const pluginServiceRegistry = new _public.PluginServiceRegistry(pluginServiceProviders);
exports.pluginServiceRegistry = pluginServiceRegistry;