"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataViewsServiceFactory = void 0;
var _i18n = require("../../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  esService: strings
} = _i18n.ErrorStrings;
const dataViewsServiceFactory = ({
  startPlugins
}, {
  notify
}) => ({
  getDataViews: async () => {
    try {
      const dataViews = await startPlugins.dataViews.getIdsWithTitle();
      return dataViews.map(({
        id,
        name,
        title
      }) => ({
        id,
        name,
        title
      }));
    } catch (e) {
      notify.error(e, {
        title: strings.getIndicesFetchErrorMessage()
      });
    }
    return [];
  },
  getFields: async dataViewTitle => {
    const dataView = await startPlugins.dataViews.create({
      title: dataViewTitle
    });
    return dataView.fields.filter(field => !field.name.startsWith('_')).map(field => field.name);
  },
  getDefaultDataView: async () => {
    const dataView = await startPlugins.dataViews.getDefaultDataView();
    return dataView ? {
      id: dataView.id,
      name: dataView.name,
      title: dataView.getIndexPattern()
    } : undefined;
  }
});
exports.dataViewsServiceFactory = dataViewsServiceFactory;