"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDefaultArgExpr = buildDefaultArgExpr;
exports.getArgTypeDef = getArgTypeDef;
var _interpreter = require("@kbn/interpreter");
var _expression_types = require("../expression_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getArgTypeDef(fn) {
  return _expression_types.modelRegistry.get(fn) || _expression_types.viewRegistry.get(fn) || _expression_types.transformRegistry.get(fn);
}
const buildArg = (arg, expr) => `${arg.name}=${formatExpr(expr)}`;
const filterValidArguments = args => args.filter(arg => arg !== undefined);
const formatExpr = expr => {
  if (isWithBrackets(expr)) {
    const exprWithoutBrackets = removeFigureBrackets(expr);
    return (0, _interpreter.toExpression)((0, _interpreter.fromExpression)(exprWithoutBrackets));
  }
  return expr;
};
const removeFigureBrackets = expr => {
  if (isWithBrackets(expr)) {
    return expr.substring(1, expr.length - 1);
  }
  return expr;
};
const isWithBrackets = expr => expr[0] === '{' && expr[expr.length - 1] === '}';
function buildDefaultArgExpr(argUiConfig) {
  const argConfig = getArgTypeDef(argUiConfig.argType);
  if (argUiConfig.default) {
    return buildArg(argUiConfig, argUiConfig.default);
  }
  if (!argConfig) {
    return undefined;
  }
  const defaultArgs = argConfig.args.map(arg => {
    const argConf = getArgTypeDef(arg.argType);
    if (arg.default && argConf && Array.isArray(argConf.args)) {
      return buildArg(arg, arg.default);
    }
    return buildDefaultArgExpr(arg);
  });
  const validArgs = filterValidArguments(defaultArgs);
  const defExpr = validArgs.length ? `{${argUiConfig.argType} ${validArgs.join(' ')}}` : `{${argUiConfig.argType}}`;
  return defExpr;
}