"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _recompose = require("recompose");
var _app_handler_creators = require("../../../lib/app_handler_creators");
var _elements = require("../../../state/actions/elements");
var _transient = require("../../../state/actions/transient");
var _workpad = require("../../../state/actions/workpad");
var _app = require("../../../state/selectors/app");
var _workpad2 = require("../../../state/selectors/workpad");
var _workpad3 = require("../../../routes/workpad");
var _view_menu = require("./view_menu.component");
var _get_fit_zoom_scale = require("./lib/get_fit_zoom_scale");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

// @ts-expect-error untyped local

const mapStateToProps = state => {
  return {
    zoomScale: (0, _app.getZoomScale)(state),
    boundingBox: (0, _workpad2.getWorkpadBoundingBox)(state),
    workpadWidth: (0, _workpad2.getWorkpadWidth)(state),
    workpadHeight: (0, _workpad2.getWorkpadHeight)(state),
    isWriteable: (0, _workpad2.isWriteable)(state) && (0, _app.canUserWrite)(state)
  };
};
const mapDispatchToProps = dispatch => ({
  setZoomScale: scale => dispatch((0, _transient.setZoomScale)(scale)),
  setWriteable: isWorkpadWriteable => dispatch((0, _workpad.setWriteable)(isWorkpadWriteable)),
  doRefresh: () => dispatch((0, _elements.fetchAllRenderables)())
});
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    boundingBox,
    workpadWidth,
    workpadHeight,
    ...remainingStateProps
  } = stateProps;
  return {
    ...remainingStateProps,
    ...dispatchProps,
    ...ownProps,
    toggleWriteable: () => dispatchProps.setWriteable(!stateProps.isWriteable),
    fitToWindow: () => dispatchProps.setZoomScale((0, _get_fit_zoom_scale.getFitZoomScale)(boundingBox, workpadWidth, workpadHeight))
  };
};
const ViewMenuWithContext = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    autoplayInterval,
    setAutoplayInterval,
    setFullscreen,
    setRefreshInterval,
    refreshInterval
  } = (0, _react.useContext)(_workpad3.WorkpadRoutingContext);
  const enterFullscreen = (0, _react.useCallback)(() => {
    dispatch((0, _transient.selectToplevelNodes)([]));
    setFullscreen(true);
  }, [dispatch, setFullscreen]);
  return /*#__PURE__*/_react.default.createElement(_view_menu.ViewMenu, (0, _extends2.default)({}, props, {
    enterFullscreen: enterFullscreen,
    setAutoplayInterval: setAutoplayInterval,
    autoplayEnabled: true,
    autoplayInterval: autoplayInterval,
    setRefreshInterval: setRefreshInterval,
    refreshInterval: refreshInterval
  }));
};
const ViewMenu = (0, _recompose.compose)((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps), (0, _recompose.withHandlers)(_app_handler_creators.zoomHandlerCreators))(ViewMenuWithContext);
exports.ViewMenu = ViewMenu;