"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFilter = void 0;
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getTypeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.defaultFilter.type', {
    defaultMessage: 'Type'
  }),
  getColumnLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.defaultFilter.column', {
    defaultMessage: 'Column'
  }),
  getFilterGroupLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.defaultFilter.filterGroup', {
    defaultMessage: 'Filter group'
  }),
  getValueLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.defaultFilter.value', {
    defaultMessage: 'Value'
  })
};
const defaultFilter = {
  name: 'default',
  view: {
    column: {
      label: strings.getColumnLabel()
    },
    value: {
      label: strings.getValueLabel()
    },
    type: {
      label: strings.getTypeLabel(),
      formatter: (0, _utils.formatByKey)('type')
    },
    filterGroup: {
      label: strings.getFilterGroupLabel()
    }
  }
};
exports.defaultFilter = defaultFilter;