"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadApp = exports.WORKPAD_CONTAINER_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("../../../i18n");
var _sidebar = require("../sidebar");
var _toolbar = require("../toolbar");
var _workpad = require("../workpad");
var _workpad_header = require("../workpad_header");
var _constants = require("../../../common/lib/constants");
var _doc_title = require("../../lib/doc_title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WORKPAD_CONTAINER_ID = 'canvasWorkpadContainer';
exports.WORKPAD_CONTAINER_ID = WORKPAD_CONTAINER_ID;
const WorkpadApp = ({
  deselectElement,
  isWriteable,
  workpad
}) => {
  const interactivePageLayout = (0, _react.useRef)(null); // future versions may enable editing on multiple pages => use array then
  const workpadTitle = (0, _react.useRef)(null); // future versions may enable editing on multiple pages => use array then

  // TODO: Remove this focus when https://github.com/elastic/kibana/issues/38980 is addressed
  (0, _react.useEffect)(() => {
    var _workpadTitle$current;
    (_workpadTitle$current = workpadTitle.current) === null || _workpadTitle$current === void 0 ? void 0 : _workpadTitle$current.focus();
  }, [workpadTitle]);
  const registerLayout = (0, _react.useCallback)(newLayout => {
    if (interactivePageLayout.current !== newLayout) {
      interactivePageLayout.current = newLayout;
    }
  }, []);
  const unregisterLayout = (0, _react.useCallback)(oldLayout => {
    if (interactivePageLayout.current === oldLayout) {
      interactivePageLayout.current = null;
    }
  }, []);
  const commit = interactivePageLayout.current || (() => {});
  const untitledWorkpadLabel = (0, _react.useMemo)(() => (0, _doc_title.getUntitledWorkpadLabel)(), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__rows"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__cols"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__stage"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__stageHeader"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "canvasWorkpadTitle",
    className: "euiScreenReaderOnly",
    ref: workpadTitle,
    tabIndex: -1
  }, `${_i18n.CANVAS} - ${workpad.name || untitledWorkpadLabel}`), /*#__PURE__*/_react.default.createElement(_workpad_header.WorkpadHeader, {
    commit: commit
  })), /*#__PURE__*/_react.default.createElement("div", {
    id: _constants.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR,
    className: _constants.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: WORKPAD_CONTAINER_ID,
    className: "canvasWorkpadContainer canvasLayout__stageContentOverflow"
  }, /*#__PURE__*/_react.default.createElement(_workpad.Workpad, {
    registerLayout: registerLayout,
    unregisterLayout: unregisterLayout
  })))), isWriteable && /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__sidebar hide-for-sharing"
  }, /*#__PURE__*/_react.default.createElement(_sidebar.Sidebar, {
    commit: commit
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__footer hide-for-sharing"
  }, /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, null))));
};
exports.WorkpadApp = WorkpadApp;
WorkpadApp.propTypes = {
  isWriteable: _propTypes.default.bool.isRequired,
  deselectElement: _propTypes.default.func
};