"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeEmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../i18n/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HomeEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceAround",
  alignItems: "center",
  style: {
    minHeight: 600
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: "subdued",
  borderRadius: "none",
  hasShadow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  color: "subdued",
  iconType: "importAction",
  title: /*#__PURE__*/_react.default.createElement("h2", null, strings.getEmptyPromptTitle()),
  titleSize: "m",
  body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, strings.getEmptyPromptGettingStartedDescription()), /*#__PURE__*/_react.default.createElement("p", null, strings.getEmptyPromptNewUserDescription(), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "home#/tutorial_directory/sampleData"
  }, strings.getSampleDataLinkLabel()), "."))
}))));
exports.HomeEmptyPrompt = HomeEmptyPrompt;
const strings = {
  getEmptyPromptGettingStartedDescription: () => _i18n.i18n.translate('xpack.canvas.homeEmptyPrompt.emptyPromptGettingStartedDescription', {
    defaultMessage: 'Create a new workpad, start from a template, or import a workpad {JSON} file by dropping it here.',
    values: {
      JSON: _constants.JSON
    }
  }),
  getEmptyPromptNewUserDescription: () => _i18n.i18n.translate('xpack.canvas.homeEmptyPrompt.emptyPromptNewUserDescription', {
    defaultMessage: 'New to {CANVAS}?',
    values: {
      CANVAS: _constants.CANVAS
    }
  }),
  getEmptyPromptTitle: () => _i18n.i18n.translate('xpack.canvas.homeEmptyPrompt.emptyPromptTitle', {
    defaultMessage: 'Add your first workpad'
  }),
  getSampleDataLinkLabel: () => _i18n.i18n.translate('xpack.canvas.homeEmptyPrompt.sampleDataLinkLabel', {
    defaultMessage: 'Add your first workpad'
  })
};