"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _interpreter = require("@kbn/interpreter");
var _services = require("../../services");
var _workpad = require("../../state/selectors/workpad");
var _elements = require("../../state/actions/elements");
var _element_not_selected = require("./element_not_selected");
var _expression = require("./expression");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

// @ts-expect-error

const Expression = ({
  done
}) => {
  const {
    element,
    pageId
  } = (0, _reactRedux.useSelector)(state => ({
    pageId: (0, _workpad.getSelectedPage)(state),
    element: (0, _workpad.getSelectedElement)(state)
  }));
  if (!element) {
    return /*#__PURE__*/_react.default.createElement(_element_not_selected.ElementNotSelected, {
      done: done
    });
  }
  return /*#__PURE__*/_react.default.createElement(ExpressionContainer, {
    key: element.id,
    done: done,
    element: element,
    pageId: pageId
  });
};
exports.Expression = Expression;
const ExpressionContainer = ({
  done,
  element,
  pageId
}) => {
  const expressions = (0, _services.useExpressionsService)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isCompact, setCompact] = (0, _react.useState)(true);
  const toggleCompactView = (0, _react.useCallback)(() => {
    setCompact(!isCompact);
  }, [isCompact, setCompact]);
  const dispatchSetExpression = (0, _react.useCallback)(expression => {
    // destroy the context cache
    dispatch((0, _elements.flushContext)(element.id));

    // update the element's expression
    dispatch((0, _elements.setExpression)(expression, element.id, pageId));
  }, [dispatch, element, pageId]);
  const [formState, setFormState] = (0, _react.useState)({
    dirty: false,
    expression: element.expression
  });
  const updateValue = (0, _react.useCallback)((expression = '') => {
    setFormState({
      expression,
      dirty: true
    });
  }, [setFormState]);
  const onSetExpression = (0, _react.useCallback)(expression => {
    setFormState({
      ...formState,
      dirty: false
    });
    dispatchSetExpression(expression);
  }, [setFormState, dispatchSetExpression, formState]);
  const currentExpression = formState.expression;
  const error = (0, _react.useMemo)(() => {
    try {
      // TODO: We should merge the advanced UI input and this into a single validated expression input.
      (0, _interpreter.fromExpression)(currentExpression);
      return null;
    } catch (e) {
      return e.message;
    }
  }, [currentExpression]);
  (0, _react.useEffect)(() => {
    if (element.expression !== formState.expression && !formState.dirty) {
      setFormState({
        dirty: false,
        expression: element.expression
      });
    }
  }, [element, setFormState, formState]);
  const functionDefinitions = (0, _react.useMemo)(() => Object.values(expressions.getFunctions()), [expressions]);
  return /*#__PURE__*/_react.default.createElement(_expression.Expression, {
    done: done,
    isCompact: isCompact,
    functionDefinitions: functionDefinitions,
    formState: formState,
    setExpression: onSetExpression,
    toggleCompactView: toggleCompactView,
    updateValue: updateValue,
    error: error
  });
};