"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Asset = void 0;
var _reactRedux = require("react-redux");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _interpreter = require("@kbn/interpreter");
var _elements_registry = require("../../lib/elements_registry");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _assets = require("../../state/actions/assets");
var _asset = require("./asset.component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

// @ts-expect-error untyped local

// @ts-expect-error untyped local

const Asset = (0, _reactRedux.connect)(state => ({
  selectedPage: (0, _workpad.getSelectedPage)(state)
}), dispatch => ({
  onCreate: pageId => assetId => {
    const imageElement = _elements_registry.elementsRegistry.get('image');
    const elementAST = (0, _interpreter.fromExpression)(imageElement.expression);
    const selector = ['chain', '0', 'arguments', 'dataurl'];
    const subExp = [{
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'asset',
        arguments: {
          _: [assetId]
        }
      }]
    }];
    const newAST = (0, _saferLodashSet.set)(elementAST, selector, subExp);
    imageElement.expression = (0, _interpreter.toExpression)(newAST);
    dispatch((0, _elements.addElement)(pageId, imageElement));
  },
  onDelete: asset => dispatch((0, _assets.removeAsset)(asset.id))
}), (stateProps, dispatchProps, ownProps) => {
  const {
    onCreate,
    onDelete
  } = dispatchProps;
  return {
    ...ownProps,
    onCreate: onCreate(stateProps.selectedPage),
    onDelete
  };
})(_asset.Asset);
exports.Asset = Asset;