"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeError = void 0;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const normalizeError = err => {
  if (!err) {
    return {
      message: 'Unknown error.'
    };
  }
  if (err instanceof _.BfetchRequestError) {
    // ignoring so we can return the error as is
    // @ts-expect-error
    return err;
  }
  if (err instanceof Error) {
    return {
      message: err.message
    };
  }
  if (typeof err === 'object') {
    return {
      ...err,
      message: err.message || 'Unknown error.'
    };
  }
  return {
    message: String(err)
  };
};
exports.normalizeError = normalizeError;