"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetApmIndicesMock = createGetApmIndicesMock;
exports.expectToThrowValidationErrorWithStatusCode = expectToThrowValidationErrorWithStatusCode;
var _validation_error = require("./lib/validators/validation_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Helper function allows test to verify error was thrown,
// verify error is of the right class type, and error has

// the expected metadata such as statusCode on it
function expectToThrowValidationErrorWithStatusCode(testFn, expectedError = {}) {
  return expect(async () => {
    try {
      return await testFn();
    } catch (error) {
      if (error instanceof _validation_error.AssetsValidationError) {
        if (expectedError.statusCode) {
          expect(error.statusCode).toEqual(expectedError.statusCode);
        }
        if (expectedError.message) {
          expect(error.message).toEqual(expect.stringContaining(expectedError.message));
        }
      }
      throw error;
    }
  }).rejects.toThrow(_validation_error.AssetsValidationError);
}
function createGetApmIndicesMock() {
  return jest.fn(async client => ({
    transaction: 'apm-mock-transaction-indices',
    span: 'apm-mock-span-indices',
    error: 'apm-mock-error-indices',
    metric: 'apm-mock-metric-indices',
    onboarding: 'apm-mock-onboarding-indices',
    sourcemap: 'apm-mock-sourcemap-indices'
  }));
}