"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClientsFromContext = getClientsFromContext;
exports.validateStringAssetFilters = validateStringAssetFilters;
var _types_api = require("../../common/types_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getClientsFromContext(context) {
  const coreContext = await context.core;
  return {
    coreContext,
    elasticsearchClient: coreContext.elasticsearch.client.asCurrentUser,
    savedObjectsClient: coreContext.savedObjects.client
  };
}
function validateStringAssetFilters(q, res) {
  if (typeof q.stringFilters === 'string') {
    try {
      const parsedFilters = JSON.parse(q.stringFilters);
      if (_types_api.assetFiltersSingleKindRT.is(parsedFilters)) {
        return [null, parsedFilters];
      } else {
        return [res.badRequest(new Error(`Invalid asset filters - ${q.filters}`))];
      }
    } catch (err) {
      return [res.badRequest(err)];
    }
  }
  return [null, undefined];
}