"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetClient = void 0;
var _lodash = require("lodash");
var _get_containers = require("./accessors/containers/get_containers");
var _get_hosts = require("./accessors/hosts/get_hosts");
var _get_services = require("./accessors/services/get_services");
var _get_pods = require("./accessors/pods/get_pods");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AssetClient {
  constructor(baseOptions) {
    this.baseOptions = baseOptions;
  }
  injectOptions(options) {
    return {
      ...options,
      ...this.baseOptions
    };
  }
  async getHosts(options) {
    const withInjected = this.injectOptions(options);
    return await (0, _get_hosts.getHosts)(withInjected);
  }
  async getServices(options) {
    const withInjected = this.injectOptions(options);
    return await (0, _get_services.getServices)(withInjected);
  }
  async getContainers(options) {
    const withInjected = this.injectOptions(options);
    return await (0, _get_containers.getContainers)(withInjected);
  }
  async getPods(options) {
    const withInjected = this.injectOptions(options);
    return await (0, _get_pods.getPods)(withInjected);
  }
  async getAssets(options) {
    const withInjected = this.injectOptions(options);
    const {
      hosts
    } = await (0, _get_hosts.getHosts)(withInjected);
    const {
      services
    } = await (0, _get_services.getServices)(withInjected);
    return {
      assets: (0, _lodash.orderBy)(hosts.concat(services), ['@timestamp'], ['desc'])
    };
  }
}
exports.AssetClient = AssetClient;