"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mobileRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _comparison_rt = require("../../../common/comparison_rt");
var _get_mobile_http_requests = require("./get_mobile_http_requests");
var _get_mobile_filters = require("./get_mobile_filters");
var _get_mobile_sessions = require("./get_mobile_sessions");
var _get_mobile_stats = require("./get_mobile_stats");
var _get_mobile_location_stats = require("./get_mobile_location_stats");
var _get_mobile_terms_by_field = require("./get_mobile_terms_by_field");
var _get_mobile_main_statistics_by_field = require("./get_mobile_main_statistics_by_field");
var _get_mobile_detailed_statistics_by_field = require("./get_mobile_detailed_statistics_by_field");
var _get_mobile_most_used_charts = require("./get_mobile_most_used_charts");
var _route = require("./errors/route");
var _route2 = require("./crashes/route");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mobileFiltersRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/mobile/filters',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.partial({
      transactionType: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionType
    } = params.query;
    const filters = await (0, _get_mobile_filters.getMobileFilters)({
      kuery,
      environment,
      transactionType,
      start,
      end,
      serviceName,
      apmEventClient
    });
    return {
      mobileFilters: filters
    };
  }
});
const mobileChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/most_used_charts',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.partial({
      transactionType: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionType
    } = params.query;
    const mostUsedCharts = await (0, _get_mobile_most_used_charts.getMobileMostUsedCharts)({
      kuery,
      environment,
      transactionType,
      start,
      end,
      serviceName,
      apmEventClient
    });
    return {
      mostUsedCharts
    };
  }
});
const mobileStatsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/stats',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      transactionType: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      offset
    } = params.query;
    const stats = await (0, _get_mobile_stats.getMobileStatsPeriods)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return stats;
  }
});
const mobileLocationStatsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/location/stats',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      locationField: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      locationField,
      offset
    } = params.query;
    const locationStats = await (0, _get_mobile_location_stats.getMobileLocationStatsPeriods)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      locationField,
      offset
    });
    return locationStats;
  }
});
const sessionsChartRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/transactions/charts/sessions',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      transactionType: t.string,
      transactionName: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionName,
      offset
    } = params.query;
    const {
      currentPeriod,
      previousPeriod
    } = await (0, _get_mobile_sessions.getMobileSessions)({
      kuery,
      environment,
      transactionName,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return {
      currentPeriod,
      previousPeriod
    };
  }
});
const httpRequestsChartRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/transactions/charts/http_requests',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _comparison_rt.offsetRt, t.partial({
      transactionType: t.string,
      transactionName: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      transactionName,
      offset
    } = params.query;
    const {
      currentPeriod,
      previousPeriod
    } = await (0, _get_mobile_http_requests.getMobileHttpRequests)({
      kuery,
      environment,
      transactionName,
      start,
      end,
      serviceName,
      apmEventClient,
      offset
    });
    return {
      currentPeriod,
      previousPeriod
    };
  }
});
const mobileTermsByFieldRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/terms',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      size: _ioTsUtils.toNumberRt,
      fieldName: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      size,
      fieldName
    } = params.query;
    const terms = await (0, _get_mobile_terms_by_field.getMobileTermsByField)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      fieldName,
      size
    });
    return {
      terms
    };
  }
});
const mobileMainStatisticsByField = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/main_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      field: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      field
    } = params.query;
    return await (0, _get_mobile_main_statistics_by_field.getMobileMainStatisticsByField)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      field
    });
  }
});
const mobileDetailedStatisticsByField = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/mobile-services/{serviceName}/detailed_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, _default_api_types.environmentRt, t.type({
      field: t.string,
      fieldValues: _ioTsUtils.jsonRt.pipe(t.array(t.string))
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end,
      field,
      offset,
      fieldValues
    } = params.query;
    return await (0, _get_mobile_detailed_statistics_by_field.getMobileDetailedStatisticsByFieldPeriods)({
      kuery,
      environment,
      start,
      end,
      serviceName,
      apmEventClient,
      field,
      fieldValues,
      offset
    });
  }
});
const mobileRouteRepository = {
  ..._route.mobileErrorRoutes,
  ..._route2.mobileCrashRoutes,
  ...mobileFiltersRoute,
  ...mobileChartsRoute,
  ...sessionsChartRoute,
  ...httpRequestsChartRoute,
  ...mobileStatsRoute,
  ...mobileLocationStatsRoute,
  ...mobileTermsByFieldRoute,
  ...mobileMainStatisticsByField,
  ...mobileDetailedStatisticsByField
};
exports.mobileRouteRepository = mobileRouteRepository;