"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileErrorsTermsByField = getMobileErrorsTermsByField;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileErrorsTermsByField({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  size,
  fieldName
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const response = await apmEventClient.search(`get_mobile_terms_by_${fieldName}`, {
    apm: {
      events: [_common.ProcessorEvent.error]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        terms: {
          terms: {
            field: fieldName,
            size
          }
        }
      }
    }
  });
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.terms) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.buckets) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.map(({
    key,
    doc_count: count
  }) => ({
    label: key,
    count
  }))) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
}