"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorGroupMainStatistics = getErrorGroupMainStatistics;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _get_error_name = require("../../../lib/helpers/get_error_name");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getErrorGroupMainStatistics({
  kuery,
  serviceName,
  apmEventClient,
  environment,
  sortField,
  sortDirection = 'desc',
  start,
  end,
  maxNumberOfErrorGroups = 500,
  transactionName,
  transactionType
}) {
  var _response$aggregation, _response$aggregation2;
  // sort buckets by last occurrence of error
  const sortByLatestOccurrence = sortField === 'lastSeen';
  const maxTimestampAggKey = 'max_timestamp';
  const order = sortByLatestOccurrence ? {
    [maxTimestampAggKey]: sortDirection
  } : {
    _count: sortDirection
  };
  const response = await apmEventClient.search('get_error_group_main_statistics', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ErrorEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        error_groups: {
          terms: {
            field: _apm.ERROR_GROUP_ID,
            size: maxNumberOfErrorGroups,
            order
          },
          aggs: {
            sample: {
              top_hits: {
                size: 1,
                _source: [_apm.ERROR_LOG_MESSAGE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_EXC_HANDLED, _apm.ERROR_EXC_TYPE, _apm.ERROR_CULPRIT, _apm.ERROR_GROUP_ID, '@timestamp'],
                sort: {
                  '@timestamp': 'desc'
                }
              }
            },
            ...(sortByLatestOccurrence ? {
              [maxTimestampAggKey]: {
                max: {
                  field: '@timestamp'
                }
              }
            } : {})
          }
        }
      }
    }
  });
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.error_groups.buckets.map(bucket => {
    var _bucket$sample$hits$h, _bucket$sample$hits$h2;
    return {
      groupId: bucket.key,
      name: (0, _get_error_name.getErrorName)(bucket.sample.hits.hits[0]._source),
      lastSeen: new Date(bucket.sample.hits.hits[0]._source['@timestamp']).getTime(),
      occurrences: bucket.doc_count,
      culprit: bucket.sample.hits.hits[0]._source.error.culprit,
      handled: (_bucket$sample$hits$h = bucket.sample.hits.hits[0]._source.error.exception) === null || _bucket$sample$hits$h === void 0 ? void 0 : _bucket$sample$hits$h[0].handled,
      type: (_bucket$sample$hits$h2 = bucket.sample.hits.hits[0]._source.error.exception) === null || _bucket$sample$hits$h2 === void 0 ? void 0 : _bucket$sample$hits$h2[0].type
    };
  })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
}