"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmRuleTypeAlertFieldMap = exports.ApmRuleTypeAlertDefinition = exports.APM_RULE_TYPE_ALERT_CONTEXT = void 0;
exports.registerApmRuleTypes = registerApmRuleTypes;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _apm = require("../../../common/es_fields/apm");
var _register_transaction_duration_rule_type = require("./rule_types/transaction_duration/register_transaction_duration_rule_type");
var _register_anomaly_rule_type = require("./rule_types/anomaly/register_anomaly_rule_type");
var _register_error_count_rule_type = require("./rule_types/error_count/register_error_count_rule_type");
var _register_transaction_error_rate_rule_type = require("./rule_types/transaction_error_rate/register_transaction_error_rate_rule_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APM_RULE_TYPE_ALERT_CONTEXT = 'observability.apm';
exports.APM_RULE_TYPE_ALERT_CONTEXT = APM_RULE_TYPE_ALERT_CONTEXT;
const apmRuleTypeAlertFieldMap = {
  ..._alertsAsDataUtils.legacyExperimentalFieldMap,
  [_apm.SERVICE_NAME]: {
    type: 'keyword',
    required: false
  },
  [_apm.SERVICE_ENVIRONMENT]: {
    type: 'keyword',
    required: false
  },
  [_apm.TRANSACTION_TYPE]: {
    type: 'keyword',
    required: false
  },
  [_apm.TRANSACTION_NAME]: {
    type: 'keyword',
    required: false
  },
  [_apm.ERROR_GROUP_ID]: {
    type: 'keyword',
    required: false
  },
  [_apm.ERROR_GROUP_NAME]: {
    type: 'keyword',
    required: false
  },
  [_apm.PROCESSOR_EVENT]: {
    type: 'keyword',
    required: false
  },
  [_apm.AGENT_NAME]: {
    type: 'keyword',
    required: false
  },
  [_apm.SERVICE_LANGUAGE_NAME]: {
    type: 'keyword',
    required: false
  },
  labels: {
    type: 'object',
    dynamic: true,
    required: false
  }
};

// Defines which alerts-as-data index alerts will use
exports.apmRuleTypeAlertFieldMap = apmRuleTypeAlertFieldMap;
const ApmRuleTypeAlertDefinition = {
  context: APM_RULE_TYPE_ALERT_CONTEXT,
  mappings: {
    fieldMap: apmRuleTypeAlertFieldMap
  },
  useLegacyAlerts: true
};
exports.ApmRuleTypeAlertDefinition = ApmRuleTypeAlertDefinition;
function registerApmRuleTypes(dependencies) {
  (0, _register_transaction_duration_rule_type.registerTransactionDurationRuleType)(dependencies);
  (0, _register_anomaly_rule_type.registerAnomalyRuleType)(dependencies);
  (0, _register_error_count_rule_type.registerErrorCountRuleType)(dependencies);
  (0, _register_transaction_error_rate_rule_type.registerTransactionErrorRateRuleType)(dependencies);
}