"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.phpVariables = exports.phpLineNumbers = exports.phpHighlightLang = exports.php = void 0;
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const phpVariables = {
  apmServiceName: 'elastic_apm.service_name',
  secretToken: 'elastic_apm.secret_token',
  apmServerUrl: 'elastic_apm.server_url',
  apmEnvironment: 'elastic_apm.environment'
};
exports.phpVariables = phpVariables;
const phpHighlightLang = 'php';
exports.phpHighlightLang = phpHighlightLang;
const phpLineNumbers = {
  start: 1,
  highlight: '1, 3, 5, 7',
  annotations: {
    1: _shared_hints.serviceNameHint,
    3: _shared_hints.secretTokenHint,
    5: _shared_hints.serverUrlHint,
    7: _shared_hints.serviceEnvironmentHint
  }
};
exports.phpLineNumbers = phpLineNumbers;
const php = `${phpVariables.apmServiceName}="{{{apmServiceName}}}"

${phpVariables.secretToken}="{{{secretToken}}}"

${phpVariables.apmServerUrl}="{{{apmServerUrl}}}"

${phpVariables.apmEnvironment}="{{{apmEnvironment}}}"`;
exports.php = php;