"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setHelpExtension = setHelpExtension;
var _i18n = require("@kbn/i18n");
var _kibana = require("./components/shared/links/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setHelpExtension({
  chrome,
  http
}) {
  chrome.setHelpExtension({
    appName: _i18n.i18n.translate('xpack.apm.feedbackMenu.appName', {
      defaultMessage: 'APM'
    }),
    links: [{
      linkType: 'discuss',
      href: 'https://discuss.elastic.co/c/apm'
    }, {
      linkType: 'custom',
      href: (0, _kibana.getUpgradeAssistantHref)(http.basePath),
      content: _i18n.i18n.translate('xpack.apm.helpMenu.upgradeAssistantLink', {
        defaultMessage: 'Upgrade assistant'
      })
    }]
  });
}