"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatencyChartSelector = getLatencyChartSelector;
var _i18n = require("@kbn/i18n");
var _formatters = require("../../common/utils/formatters");
var _get_timeseries_color = require("../components/shared/charts/helper/get_timeseries_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLatencyChartSelector({
  latencyChart,
  latencyAggregationType,
  previousPeriodLabel
}) {
  if (!(latencyChart !== null && latencyChart !== void 0 && latencyChart.currentPeriod.latencyTimeseries) || !latencyAggregationType) {
    return {};
  }
  return {
    currentPeriod: getLatencyTimeseries({
      latencyChart: latencyChart.currentPeriod,
      latencyAggregationType
    }),
    previousPeriod: getPreviousPeriodTimeseries({
      previousPeriod: latencyChart.previousPeriod,
      latencyAggregationType,
      previousPeriodLabel
    })
  };
}
function getPreviousPeriodTimeseries({
  previousPeriod,
  latencyAggregationType,
  previousPeriodLabel
}) {
  var _previousPeriod$laten;
  let chartType = _get_timeseries_color.ChartType.LATENCY_AVG;
  if (latencyAggregationType === 'p95') {
    chartType = _get_timeseries_color.ChartType.LATENCY_P95;
  } else if (latencyAggregationType === 'p99') {
    chartType = _get_timeseries_color.ChartType.LATENCY_P99;
  }
  const {
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(chartType);
  return {
    data: (_previousPeriod$laten = previousPeriod.latencyTimeseries) !== null && _previousPeriod$laten !== void 0 ? _previousPeriod$laten : [],
    type: 'area',
    color: previousPeriodColor,
    title: previousPeriodLabel
  };
}
function getLatencyTimeseries({
  latencyChart,
  latencyAggregationType
}) {
  const {
    overallAvgDuration
  } = latencyChart;
  const {
    latencyTimeseries
  } = latencyChart;
  switch (latencyAggregationType) {
    case 'avg':
      {
        const {
          currentPeriodColor
        } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
        return {
          title: _i18n.i18n.translate('xpack.apm.transactions.latency.chart.averageLabel', {
            defaultMessage: 'Average'
          }),
          data: latencyTimeseries,
          legendValue: (0, _formatters.asDuration)(overallAvgDuration),
          type: 'linemark',
          color: currentPeriodColor
        };
      }
    case 'p95':
      {
        const {
          currentPeriodColor
        } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_P95);
        return {
          title: _i18n.i18n.translate('xpack.apm.transactions.latency.chart.95thPercentileLabel', {
            defaultMessage: '95th percentile'
          }),
          titleShort: '95th',
          data: latencyTimeseries,
          type: 'linemark',
          color: currentPeriodColor
        };
      }
    case 'p99':
      {
        const {
          currentPeriodColor
        } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_P99);
        return {
          title: _i18n.i18n.translate('xpack.apm.transactions.latency.chart.99thPercentileLabel', {
            defaultMessage: '99th percentile'
          }),
          titleShort: '99th',
          data: latencyTimeseries,
          type: 'linemark',
          color: currentPeriodColor
        };
      }
  }
}