"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlParamsProvider = exports.UrlParamsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _helpers = require("./helpers");
var _resolve_url_params = require("./resolve_url_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultRefresh = _time => {};
const UrlParamsContext = /*#__PURE__*/(0, _react.createContext)({
  rangeId: 0,
  refreshTimeRange: defaultRefresh,
  urlParams: {}
});
exports.UrlParamsContext = UrlParamsContext;
const UrlParamsProvider = (0, _reactRouterDom.withRouter)(({
  location,
  children
}) => {
  const refUrlParams = (0, _react.useRef)((0, _resolve_url_params.resolveUrlParams)(location, {}));
  const {
    start,
    end,
    rangeFrom,
    rangeTo
  } = refUrlParams.current;

  // Counter to force an update in useFetcher when the refresh button is clicked.
  const [rangeId, setRangeId] = (0, _react.useState)(0);
  const urlParams = (0, _react.useMemo)(() => (0, _resolve_url_params.resolveUrlParams)(location, {
    start,
    end,
    rangeFrom,
    rangeTo
  }), [location, start, end, rangeFrom, rangeTo]);
  refUrlParams.current = urlParams;
  const refreshTimeRange = (0, _react.useCallback)(timeRange => {
    refUrlParams.current = {
      ...refUrlParams.current,
      ...(0, _helpers.getDateRange)({
        state: {},
        ...timeRange
      })
    };
    setRangeId(prevRangeId => prevRangeId + 1);
  }, []);
  const contextValue = (0, _react.useMemo)(() => {
    return {
      rangeId,
      refreshTimeRange,
      urlParams
    };
  }, [rangeId, refreshTimeRange, urlParams]);
  return /*#__PURE__*/_react.default.createElement(UrlParamsContext.Provider, {
    children: children,
    value: contextValue
  });
});
exports.UrlParamsProvider = UrlParamsProvider;