"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSections = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _url = _interopRequireDefault(require("url"));
var _discover_link = require("../links/discover_links/discover_link");
var _discover_transaction_link = require("../links/discover_links/discover_transaction_link");
var _infra_link = require("../links/infra_link");
var _url_helpers = require("../links/url_helpers");
var _sections_helper = require("./sections_helper");
var _apm = require("../../../../common/es_fields/apm");
var _observability_logs_link = require("../links/observability_logs_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInfraMetricsQuery(transaction) {
  const timestamp = new Date(transaction['@timestamp']).getTime();
  const fiveMinutes = _moment.default.duration(5, 'minutes').asMilliseconds();
  return {
    from: timestamp - fiveMinutes,
    to: timestamp + fiveMinutes
  };
}
const getSections = ({
  transaction,
  basePath,
  location,
  apmRouter,
  infraLinksAvailable,
  profilingLocators,
  rangeFrom,
  rangeTo,
  environment,
  allDatasetsLocator,
  logsLocator,
  nodeLogsLocator,
  dataViewId
}) => {
  var _transaction$host, _transaction$kubernet, _transaction$kubernet2, _transaction$containe, _transaction$url, _transaction$url2;
  if (!transaction || !dataViewId) return [];
  const hostName = (_transaction$host = transaction.host) === null || _transaction$host === void 0 ? void 0 : _transaction$host.hostname;
  const podId = (_transaction$kubernet = transaction.kubernetes) === null || _transaction$kubernet === void 0 ? void 0 : (_transaction$kubernet2 = _transaction$kubernet.pod) === null || _transaction$kubernet2 === void 0 ? void 0 : _transaction$kubernet2.uid;
  const containerId = (_transaction$containe = transaction.container) === null || _transaction$containe === void 0 ? void 0 : _transaction$containe.id;
  const time = Math.round(transaction.timestamp.us / 1000);
  const infraMetricsQuery = getInfraMetricsQuery(transaction);
  const uptimeLink = _url.default.format({
    pathname: basePath.prepend('/app/uptime'),
    search: `?${(0, _url_helpers.fromQuery)((0, _lodash.pickBy)({
      dateRangeStart: rangeFrom,
      dateRangeEnd: rangeTo,
      search: `url.domain:"${(_transaction$url = transaction.url) === null || _transaction$url === void 0 ? void 0 : _transaction$url.domain}"`
    }, val => !(0, _lodash.isEmpty)(val)))}`
  });

  // Logs hrefs
  const podLogsHref = (0, _observability_logs_link.getNodeLogsHref)('pod', podId, time, allDatasetsLocator, nodeLogsLocator);
  const containerLogsHref = (0, _observability_logs_link.getNodeLogsHref)('container', containerId, time, allDatasetsLocator, nodeLogsLocator);
  const hostLogsHref = (0, _observability_logs_link.getNodeLogsHref)('host', hostName, time, allDatasetsLocator, nodeLogsLocator);
  const traceLogsHref = (0, _observability_logs_link.getTraceLogsHref)(transaction.trace.id, time, allDatasetsLocator, logsLocator);
  const podActions = [{
    key: 'podLogs',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showPodLogsLinkLabel', {
      defaultMessage: 'Pod logs'
    }),
    href: podLogsHref,
    condition: !!podId
  }, {
    key: 'podMetrics',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showPodMetricsLinkLabel', {
      defaultMessage: 'Pod metrics'
    }),
    href: (0, _infra_link.getInfraHref)({
      app: 'metrics',
      basePath,
      path: `/link-to/pod-detail/${podId}`,
      query: infraMetricsQuery
    }),
    condition: !!podId && infraLinksAvailable
  }];
  const containerActions = [{
    key: 'containerLogs',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showContainerLogsLinkLabel', {
      defaultMessage: 'Container logs'
    }),
    href: containerLogsHref,
    condition: !!containerId
  }, {
    key: 'containerMetrics',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showContainerMetricsLinkLabel', {
      defaultMessage: 'Container metrics'
    }),
    href: (0, _infra_link.getInfraHref)({
      app: 'metrics',
      basePath,
      path: `/link-to/container-detail/${containerId}`,
      query: infraMetricsQuery
    }),
    condition: !!containerId && infraLinksAvailable
  }];
  const hostActions = [{
    key: 'hostLogs',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showHostLogsLinkLabel', {
      defaultMessage: 'Host logs'
    }),
    href: hostLogsHref,
    condition: !!hostName
  }, {
    key: 'hostMetrics',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showHostMetricsLinkLabel', {
      defaultMessage: 'Host metrics'
    }),
    href: (0, _infra_link.getInfraHref)({
      app: 'metrics',
      basePath,
      path: `/link-to/host-detail/${hostName}`,
      query: infraMetricsQuery
    }),
    condition: !!hostName && infraLinksAvailable
  }, {
    key: 'hostProfilingFlamegraph',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showHostProfilingFlamegraphLinkLabel', {
      defaultMessage: 'Host flamegraph'
    }),
    href: profilingLocators === null || profilingLocators === void 0 ? void 0 : profilingLocators.flamegraphLocator.getRedirectUrl({
      kuery: `${_apm.HOST_NAME}: "${hostName}"`
    }),
    condition: !!hostName && !!profilingLocators,
    showNewBadge: true
  }, {
    key: 'hostProfilingTopNFunctions',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showHostProfilingTopNFunctionsLinkLabel', {
      defaultMessage: 'Host topN functions'
    }),
    href: profilingLocators === null || profilingLocators === void 0 ? void 0 : profilingLocators.topNFunctionsLocator.getRedirectUrl({
      kuery: `${_apm.HOST_NAME}: "${hostName}"`
    }),
    condition: !!hostName && !!profilingLocators,
    showNewBadge: true
  }, {
    key: 'hostProfilingStacktraces',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showHostProfilingStacktracesLinkLabel', {
      defaultMessage: 'Host stacktraces'
    }),
    href: profilingLocators === null || profilingLocators === void 0 ? void 0 : profilingLocators.stacktracesLocator.getRedirectUrl({
      kuery: `${_apm.HOST_NAME}: "${hostName}"`
    }),
    condition: !!hostName && !!profilingLocators,
    showNewBadge: true
  }];
  const logActions = [{
    key: 'traceLogs',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showTraceLogsLinkLabel', {
      defaultMessage: 'Trace logs'
    }),
    href: traceLogsHref,
    condition: true
  }];
  const uptimeActions = [{
    key: 'monitorStatus',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.viewInUptime', {
      defaultMessage: 'Status'
    }),
    href: uptimeLink,
    condition: !!((_transaction$url2 = transaction.url) !== null && _transaction$url2 !== void 0 && _transaction$url2.domain)
  }];
  const kibanaActions = [{
    key: 'sampleDocument',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.viewSampleDocumentLinkLabel', {
      defaultMessage: 'View transaction in Discover'
    }),
    href: (0, _discover_link.getDiscoverHref)({
      basePath,
      query: (0, _discover_transaction_link.getDiscoverQuery)(transaction),
      location,
      dataViewId
    }),
    condition: true
  }];
  const serviceMapHref = apmRouter.link('/service-map', {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery: `${_apm.TRACE_ID} : "${transaction.trace.id}"`,
      serviceGroup: '',
      comparisonEnabled: false
    }
  });
  const serviceMapActions = [{
    key: 'serviceMap',
    label: _i18n.i18n.translate('xpack.apm.transactionActionMenu.showInServiceMapLinkLabel', {
      defaultMessage: 'Show in service map'
    }),
    href: serviceMapHref,
    condition: true
  }];
  const sectionRecord = {
    observability: [{
      key: 'podDetails',
      title: _i18n.i18n.translate('xpack.apm.transactionActionMenu.pod.title', {
        defaultMessage: 'Pod details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.transactionActionMenu.pod.subtitle', {
        defaultMessage: 'View logs and metrics for this pod to get further details.'
      }),
      actions: podActions
    }, {
      key: 'containerDetails',
      title: _i18n.i18n.translate('xpack.apm.transactionActionMenu.container.title', {
        defaultMessage: 'Container details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.transactionActionMenu.container.subtitle', {
        defaultMessage: 'View logs and metrics for this container to get further details.'
      }),
      actions: containerActions
    }, {
      key: 'hostDetails',
      title: _i18n.i18n.translate('xpack.apm.transactionActionMenu.host.title', {
        defaultMessage: 'Host details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.transactionActionMenu.host.subtitle', {
        defaultMessage: 'View host logs and metrics to get further details.'
      }),
      actions: hostActions
    }, {
      key: 'traceDetails',
      title: _i18n.i18n.translate('xpack.apm.transactionActionMenu.trace.title', {
        defaultMessage: 'Trace details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.transactionActionMenu.trace.subtitle', {
        defaultMessage: 'View trace logs to get further details.'
      }),
      actions: logActions
    }, {
      key: 'statusDetails',
      title: _i18n.i18n.translate('xpack.apm.transactionActionMenu.status.title', {
        defaultMessage: 'Status details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.transactionActionMenu.status.subtitle', {
        defaultMessage: 'View status to get further details.'
      }),
      actions: uptimeActions
    }, {
      key: 'serviceMap',
      title: _i18n.i18n.translate('xpack.apm.transactionActionMenu.serviceMap.title', {
        defaultMessage: 'Service Map'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.transactionActionMenu.serviceMap.subtitle', {
        defaultMessage: 'View service map filtered by this trace.'
      }),
      actions: serviceMapActions
    }],
    kibana: [{
      key: 'kibana',
      actions: kibanaActions
    }]
  };

  // Filter out actions that shouldnt be shown and sections without any actions.
  return (0, _sections_helper.getNonEmptySections)(sectionRecord);
};
exports.getSections = getSections;