"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkMenuSection = CustomLinkMenuSection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _custom_link = require("../../../../../common/custom_link");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _helper = require("../../../app/settings/custom_link/create_edit_custom_link_flyout/helper");
var _loading_state_prompt = require("../../loading_state_prompt");
var _custom_link_toolbar = require("./custom_link_toolbar");
var _custom_link_list = require("./custom_link_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LINKS_TO_SHOW = 3;
function CustomLinkMenuSection({
  transaction,
  openCreateCustomLinkFlyout
}) {
  var _data$customLinks;
  const [showAllLinks, setShowAllLinks] = (0, _react.useState)(false);
  const filters = (0, _react.useMemo)(() => [{
    key: 'service.name',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.service.name
  }, {
    key: 'service.environment',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.service.environment
  }, {
    key: 'transaction.name',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.name
  }, {
    key: 'transaction.type',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.type
  }].filter(filter => typeof filter.value === 'string'), [transaction]);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/settings/custom_links', {
    isCachable: false,
    params: {
      query: (0, _helper.convertFiltersToQuery)(filters)
    }
  }), [filters]);
  const customLinks = (_data$customLinks = data === null || data === void 0 ? void 0 : data.customLinks) !== null && _data$customLinks !== void 0 ? _data$customLinks : [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.ActionMenuDivider, null), /*#__PURE__*/_react.default.createElement(_public.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.SectionTitle, null, _i18n.i18n.translate('xpack.apm.transactionActionMenu.customLink.section', {
    defaultMessage: 'Custom Links'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_custom_link_toolbar.CustomLinkToolbar, {
    onClickCreate: openCreateCustomLinkFlyout,
    showCreateButton: customLinks.length > 0
  }))), /*#__PURE__*/_react.default.createElement(_public.SectionSubtitle, null, _i18n.i18n.translate('xpack.apm.transactionActionMenu.customLink.subtitle', {
    defaultMessage: 'Links will open in a new window.'
  })), /*#__PURE__*/_react.default.createElement(_custom_link_list.CustomLinkList, {
    customLinks: showAllLinks ? customLinks : customLinks.slice(0, DEFAULT_LINKS_TO_SHOW),
    transaction: transaction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(BottomSection, {
    status: status,
    customLinks: customLinks,
    showAllLinks: showAllLinks,
    toggleShowAll: () => setShowAllLinks(show => !show),
    onClickCreate: openCreateCustomLinkFlyout
  })));
}
function BottomSection({
  status,
  customLinks,
  showAllLinks,
  toggleShowAll,
  onClickCreate
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canSave = !!core.application.capabilities.apm.save;
  if (status === _use_fetcher.FETCH_STATUS.LOADING) {
    return /*#__PURE__*/_react.default.createElement(_loading_state_prompt.LoadingStatePrompt, null);
  }

  // render empty prompt if there are no custom links
  if ((0, _lodash.isEmpty)(customLinks)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      grow: false,
      style: {
        width: 300
      }
    }, _i18n.i18n.translate('xpack.apm.customLink.empty', {
      defaultMessage: 'No custom links found. Set up your own custom links, e.g., a link to a specific Dashboard or external link.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        alignItems: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: !canSave && _custom_link.NO_PERMISSION_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmBottomSectionCreateCustomLinkButton",
      isDisabled: !canSave,
      iconType: "plusInCircle",
      size: "xs",
      onClick: onClickCreate
    }, _i18n.i18n.translate('xpack.apm.customLink.buttom.create', {
      defaultMessage: 'Create custom link'
    })))));
  }

  // render button to toggle "Show all" / "Show fewer"
  if (customLinks.length > DEFAULT_LINKS_TO_SHOW) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmBottomSectionButton",
      iconType: showAllLinks ? 'arrowUp' : 'arrowDown',
      onClick: toggleShowAll
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, showAllLinks ? _i18n.i18n.translate('xpack.apm.transactionActionMenu.customLink.showFewer', {
      defaultMessage: 'Show fewer'
    }) : _i18n.i18n.translate('xpack.apm.transactionActionMenu.customLink.showAll', {
      defaultMessage: 'Show all'
    })))));
  }
  return null;
}