"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkFlyout = CustomLinkFlyout;
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _helper = require("../../app/settings/custom_link/create_edit_custom_link_flyout/helper");
var _create_edit_custom_link_flyout = require("../../app/settings/custom_link/create_edit_custom_link_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLinkFlyout({
  transaction,
  isOpen,
  onClose
}) {
  const filters = (0, _react.useMemo)(() => [{
    key: 'service.name',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.service.name
  }, {
    key: 'service.environment',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.service.environment
  }, {
    key: 'transaction.name',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.name
  }, {
    key: 'transaction.type',
    value: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.type
  }].filter(filter => typeof filter.value === 'string'), [transaction]);
  const {
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/settings/custom_links', {
    isCachable: false,
    params: {
      query: (0, _helper.convertFiltersToQuery)(filters)
    }
  }), [filters]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOpen && /*#__PURE__*/_react.default.createElement(_create_edit_custom_link_flyout.CreateEditCustomLinkFlyout, {
    defaults: {
      filters
    },
    onClose: () => {
      onClose();
    },
    onSave: () => {
      onClose();
      refetch();
    },
    onDelete: () => {
      onClose();
      refetch();
    }
  }));
}