"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Context = Context;
var _lodash = require("lodash");
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _reactSyntaxHighlighter = require("react-syntax-highlighter");
var _javascript = _interopRequireDefault(require("react-syntax-highlighter/dist/cjs/languages/hljs/javascript"));
var _python = _interopRequireDefault(require("react-syntax-highlighter/dist/cjs/languages/hljs/python"));
var _ruby = _interopRequireDefault(require("react-syntax-highlighter/dist/cjs/languages/hljs/ruby"));
var _xcode = _interopRequireDefault(require("react-syntax-highlighter/dist/cjs/styles/hljs/xcode"));
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_reactSyntaxHighlighter.Light.registerLanguage('javascript', _javascript.default);
_reactSyntaxHighlighter.Light.registerLanguage('python', _python.default);
_reactSyntaxHighlighter.Light.registerLanguage('ruby', _ruby.default);
const ContextContainer = _common.euiStyled.div`
  position: relative;
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
`;
const LINE_HEIGHT = 18;
const LineHighlight = _common.euiStyled.div`
  position: absolute;
  width: 100%;
  height: ${LINE_HEIGHT}px;
  top: ${props => props.lineNumber * LINE_HEIGHT}px;
  pointer-events: none;
  background-color: ${({
  theme
}) => (0, _polished.tint)(0.9, theme.eui.euiColorWarning)};
`;
const LineNumberContainer = _common.euiStyled.div`
  position: absolute;
  top: 0;
  left: 0;
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
  background: ${({
  isLibraryFrame,
  theme
}) => isLibraryFrame ? theme.eui.euiColorEmptyShade : theme.eui.euiColorLightestShade};
`;
const LineNumber = _common.euiStyled.div`
  position: relative;
  min-width: 42px;
  padding-left: ${({
  theme
}) => theme.eui.euiSizeS};
  padding-right: ${({
  theme
}) => theme.eui.euiSizeXS};
  color: ${({
  theme
}) => theme.eui.euiColorMediumShade};
  line-height: ${LINE_HEIGHT}px;
  text-align: right;
  border-right: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  background-color: ${({
  highlight,
  theme
}) => highlight ? (0, _polished.tint)(0.9, theme.eui.euiColorWarning) : null};

  &:last-of-type {
    border-radius: 0 0 0 ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
  }
`;
const LineContainer = _common.euiStyled.div`
  overflow: auto;
  margin: 0 0 0 42px;
  padding: 0;
  background-color: ${({
  theme
}) => theme.eui.euiColorEmptyShade};

  &:last-of-type {
    border-radius: 0 0 ${({
  theme
}) => theme.eui.euiBorderRadiusSmall} 0;
  }
`;
const Line = _common.euiStyled.pre`
  // Override all styles
  margin: 0;
  color: inherit;
  background: inherit;
  border: 0;
  border-radius: 0;
  overflow: initial;
  padding: 0 ${LINE_HEIGHT}px;
  line-height: ${LINE_HEIGHT}px;
`;
const Code = _common.euiStyled.code`
  position: relative;
  padding: 0;
  margin: 0;
  white-space: pre;
  z-index: 2;
`;
function getStackframeLines(stackframe) {
  var _stackframe$context, _stackframe$context2;
  const line = stackframe.line.context;
  const preLines = ((_stackframe$context = stackframe.context) === null || _stackframe$context === void 0 ? void 0 : _stackframe$context.pre) || [];
  const postLines = ((_stackframe$context2 = stackframe.context) === null || _stackframe$context2 === void 0 ? void 0 : _stackframe$context2.post) || [];
  return [...preLines, line, ...postLines].map(x => (x.endsWith('\n') ? x.slice(0, -1) : x) || ' ');
}
function getStartLineNumber(stackframe) {
  var _stackframe$context3;
  const preLines = (0, _lodash.size)(((_stackframe$context3 = stackframe.context) === null || _stackframe$context3 === void 0 ? void 0 : _stackframe$context3.pre) || []);
  return stackframe.line.number - preLines;
}
function Context({
  stackframe,
  codeLanguage,
  isLibraryFrame
}) {
  var _stackframe$context4;
  const lines = getStackframeLines(stackframe);
  const startLineNumber = getStartLineNumber(stackframe);
  const highlightedLineIndex = (0, _lodash.size)(((_stackframe$context4 = stackframe.context) === null || _stackframe$context4 === void 0 ? void 0 : _stackframe$context4.pre) || []);
  const language = codeLanguage || 'javascript'; // TODO: Add support for more languages

  return /*#__PURE__*/_react.default.createElement(ContextContainer, null, /*#__PURE__*/_react.default.createElement(LineHighlight, {
    lineNumber: highlightedLineIndex
  }), /*#__PURE__*/_react.default.createElement(LineNumberContainer, {
    isLibraryFrame: isLibraryFrame
  }, lines.map((line, i) => /*#__PURE__*/_react.default.createElement(LineNumber, {
    key: line + i,
    highlight: highlightedLineIndex === i
  }, i + startLineNumber, "."))), /*#__PURE__*/_react.default.createElement(LineContainer, null, lines.map((line, i) => /*#__PURE__*/_react.default.createElement(_reactSyntaxHighlighter.Light, {
    key: line + i,
    language: language,
    style: _xcode.default,
    PreTag: Line,
    CodeTag: Code,
    customStyle: {
      padding: undefined,
      overflowX: undefined
    }
  }, line))));
}