"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedTable = void 0;
exports.UnoptimizedManagedTable = UnoptimizedManagedTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _url_helpers = require("../links/url_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: this should really be imported from EUI

const PAGE_SIZE_OPTIONS = [10, 25, 50];
function defaultSortFn(items, sortField, sortDirection) {
  return (0, _lodash.orderBy)(items, sortField, sortDirection);
}
function UnoptimizedManagedTable(props) {
  var _props$columns$;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    items,
    columns,
    initialPageIndex = 0,
    initialPageSize,
    initialSortField = ((_props$columns$ = props.columns[0]) === null || _props$columns$ === void 0 ? void 0 : _props$columns$.field) || '',
    initialSortDirection = 'asc',
    showPerPageOptions = true,
    noItemsMessage,
    sortItems = true,
    sortFn = defaultSortFn,
    pagination = true,
    isLoading = false,
    error = false,
    tableLayout
  } = props;
  const {
    urlParams: {
      page = initialPageIndex,
      pageSize = initialPageSize,
      sortField = initialSortField,
      sortDirection = initialSortDirection
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const renderedItems = (0, _react.useMemo)(() => {
    const sortedItems = sortItems ? sortFn(items, sortField, sortDirection) : items;
    return sortedItems.slice(page * pageSize, (page + 1) * pageSize);
  }, [page, pageSize, sortField, sortDirection, items, sortItems, sortFn]);
  const sort = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortField, sortDirection]);
  const onTableChange = (0, _react.useCallback)(options => {
    var _options$sort, _options$sort2;
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        page: options.page.index,
        pageSize: options.page.size,
        sortField: (_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field,
        sortDirection: (_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction
      })
    });
  }, [history]);
  const paginationProps = (0, _react.useMemo)(() => {
    if (!pagination) {
      return;
    }
    return {
      showPerPageOptions,
      totalItemCount: items.length,
      pageIndex: page,
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
  }, [showPerPageOptions, items, page, pageSize, pagination]);
  const showNoItemsMessage = (0, _react.useMemo)(() => {
    return isLoading ? _i18n.i18n.translate('xpack.apm.managedTable.loadingDescription', {
      defaultMessage: 'Loading…'
    }) : noItemsMessage;
  }, [isLoading, noItemsMessage]);
  return (
    /*#__PURE__*/
    // @ts-expect-error TS thinks pagination should be non-nullable, but it's not
    _react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
      loading: isLoading,
      tableLayout: tableLayout,
      error: error ? _i18n.i18n.translate('xpack.apm.managedTable.errorMessage', {
        defaultMessage: 'Failed to fetch'
      }) : '',
      noItemsMessage: showNoItemsMessage,
      items: renderedItems,
      columns: columns // EuiBasicTableColumn is stricter than ITableColumn
      ,
      sorting: sort,
      onChange: onTableChange
    }, paginationProps ? {
      pagination: paginationProps
    } : {}))
  );
}
const ManagedTable = /*#__PURE__*/_react.default.memo(UnoptimizedManagedTable);
exports.ManagedTable = ManagedTable;