"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useServiceNodeOverviewHref = useServiceNodeOverviewHref;
var _apm_link = require("./apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistedFilters = ['host', 'containerId', 'podName', 'serviceVersion'];
function useServiceNodeOverviewHref(serviceName) {
  return (0, _apm_link.useAPMHref)({
    path: `/services/${serviceName}/nodes`,
    persistedFilters
  });
}