"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceMapLink = ServiceMapLink;
exports.useServiceMapHref = useServiceMapHref;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _apm_link = require("./apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useServiceMapHref(serviceName) {
  const path = serviceName ? `/services/${serviceName}/service-map` : '/service-map';
  return (0, _apm_link.useAPMHref)({
    path
  });
}
function ServiceMapLink({
  serviceName,
  ...rest
}) {
  const href = useServiceMapHref(serviceName);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmServiceMapLinkLink",
    href: href
  }, rest));
}