"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _common = require("@kbn/kibana-react-plugin/common");
var _eui = require("@elastic/eui");
var _style = require("../../../../utils/style");
var _polished = require("polished");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIconColor(type, theme) {
  switch (type) {
    case 'field':
      return theme.eui.euiColorVis7;
    case 'value':
      return theme.eui.euiColorVis0;
    case 'operator':
      return theme.eui.euiColorVis1;
    case 'conjunction':
      return theme.eui.euiColorVis3;
    case 'recentSearch':
      return theme.eui.euiColorMediumShade;
  }
}
const Description = _common.euiStyled.div`
  color: ${({
  theme
}) => theme.eui.euiColorDarkShade};

  p {
    display: inline;

    span {
      font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
      color: ${({
  theme
}) => theme.eui.euiColorFullShade};
      padding: 0 ${({
  theme
}) => theme.eui.euiSizeXS};
      display: inline-block;
    }
  }
`;
const ListItem = _common.euiStyled.li`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  height: ${({
  theme
}) => theme.eui.euiSizeXL};
  align-items: center;
  display: flex;
  background: ${({
  selected,
  theme
}) => selected ? theme.eui.euiColorLightestShade : 'initial'};
  cursor: pointer;
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};

  ${Description} {
    p span {
      background: ${({
  selected,
  theme
}) => selected ? theme.eui.euiColorEmptyShade : theme.eui.euiColorLightestShade};
    }
  }
`;
const Icon = _common.euiStyled.div`
  flex: 0 0 ${({
  theme
}) => theme.eui.euiSizeXL};
  background: ${({
  type,
  theme
}) => (0, _polished.tint)(0.9, getIconColor(type, theme))};
  color: ${({
  type,
  theme
}) => getIconColor(type, theme)};
  width: 100%;
  height: 100%;
  text-align: center;
  line-height: ${({
  theme
}) => theme.eui.euiSizeXL};
`;
const TextValue = _common.euiStyled.div`
  flex: 0 0 ${_style.unit * 16}px;
  color: ${({
  theme
}) => theme.eui.euiColorDarkestShade};
  padding: 0 ${({
  theme
}) => theme.eui.euiSizeS};
`;
function getEuiIconType(type) {
  switch (type) {
    case 'field':
      return 'kqlField';
    case 'value':
      return 'kqlValue';
    case 'recentSearch':
      return 'search';
    case 'conjunction':
      return 'kqlSelector';
    case 'operator':
      return 'kqlOperand';
    default:
      throw new Error('Unknown type', type);
  }
}
function Suggestion(props) {
  return /*#__PURE__*/_react.default.createElement(ListItem, {
    innerRef: props.innerRef,
    selected: props.selected,
    onClick: () => props.onClick(props.suggestion),
    onMouseEnter: props.onMouseEnter
  }, /*#__PURE__*/_react.default.createElement(Icon, {
    type: props.suggestion.type
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getEuiIconType(props.suggestion.type)
  })), /*#__PURE__*/_react.default.createElement(TextValue, null, props.suggestion.text), /*#__PURE__*/_react.default.createElement(Description, null, props.suggestion.description));
}
Suggestion.propTypes = {
  onClick: _propTypes.default.func.isRequired,
  onMouseEnter: _propTypes.default.func.isRequired,
  selected: _propTypes.default.bool,
  suggestion: _propTypes.default.object.isRequired,
  innerRef: _propTypes.default.func.isRequired
};
var _default = Suggestion;
exports.default = _default;
module.exports = exports.default;