"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = DatePicker;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/data-plugin/common");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _call_api = require("../../../services/rest/call_api");
var _url_helpers = require("../links/url_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DatePicker({
  rangeFrom,
  rangeTo,
  refreshPaused,
  refreshInterval,
  onTimeRangeRefresh
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    core,
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const timePickerQuickRanges = core.uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  }));
  function updateUrl(nextQuery) {
    history.push({
      ...location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(location.search),
        ...nextQuery
      })
    });
  }
  function onRefreshChange({
    nextRefreshPaused,
    nextRefreshInterval
  }) {
    updateUrl({
      refreshPaused: nextRefreshPaused,
      refreshInterval: nextRefreshInterval
    });
  }
  function onTimeChange({
    start,
    end
  }) {
    updateUrl({
      rangeFrom: start,
      rangeTo: end
    });
  }
  (0, _react.useEffect)(() => {
    // set time if both to and from are given in the url
    if (rangeFrom && rangeTo) {
      plugins.data.query.timefilter.timefilter.setTime({
        from: rangeFrom,
        to: rangeTo
      });
      return;
    }
  }, [rangeFrom, rangeTo, plugins]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: rangeFrom,
    end: rangeTo,
    isPaused: refreshPaused,
    refreshInterval: refreshInterval,
    onTimeChange: onTimeChange,
    onRefresh: () => {
      (0, _call_api.clearCache)();
      onTimeRangeRefresh();
    },
    onRefreshChange: ({
      isPaused: nextRefreshPaused,
      refreshInterval: nextRefreshInterval
    }) => {
      onRefreshChange({
        nextRefreshPaused,
        nextRefreshInterval
      });
    },
    showUpdateButton: true,
    commonlyUsedRanges: commonlyUsedRanges,
    width: 'auto'
  });
}