"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.page = page;
var _react = _interopRequireDefault(require("react"));
var _breadcrumb = require("../../app/breadcrumb");
var _apm_main_template = require("../templates/apm_main_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function page({
  path,
  element,
  children,
  title,
  showServiceGroupSaveButton = false,
  params
}) {
  return {
    [path]: {
      element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
        title: title,
        href: path
      }, /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
        pageTitle: title,
        showServiceGroupSaveButton: showServiceGroupSaveButton
      }, element)),
      children,
      params
    }
  };
}