"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateExecutionContextOnRouteChange = UpdateExecutionContextOnRouteChange;
var _public = require("@kbn/kibana-react-plugin/public");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _lodash = require("lodash");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UpdateExecutionContextOnRouteChange({
  children
}) {
  var _lastMatch$match;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const lastMatch = (0, _lodash.last)((0, _typedReactRouterConfig.useMatchRoutes)());
  (0, _public.useExecutionContext)(core.executionContext, {
    type: 'application',
    name: 'apm',
    page: lastMatch === null || lastMatch === void 0 ? void 0 : (_lastMatch$match = lastMatch.match) === null || _lastMatch$match === void 0 ? void 0 : _lastMatch$match.path
  });
  return children;
}