"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionTab = void 0;
exports.TransactionTabs = TransactionTabs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/logs-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _transaction_metadata = require("../../../shared/metadata_table/transaction_metadata");
var _waterfall_container = require("./waterfall_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TransactionTab;
exports.TransactionTab = TransactionTab;
(function (TransactionTab) {
  TransactionTab["timeline"] = "timeline";
  TransactionTab["metadata"] = "metadata";
  TransactionTab["logs"] = "logs";
})(TransactionTab || (exports.TransactionTab = TransactionTab = {}));
function TransactionTabs({
  transaction,
  waterfall,
  isLoading,
  detailTab = TransactionTab.timeline,
  waterfallItemId,
  serviceName,
  onTabClick,
  showCriticalPath,
  onShowCriticalPathChange
}) {
  const tabs = (0, _react.useMemo)(() => ({
    [TransactionTab.timeline]: {
      label: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.timelineLabel', {
        defaultMessage: 'Timeline'
      }),
      component: /*#__PURE__*/_react.default.createElement(TimelineTabContent, {
        waterfallItemId: waterfallItemId,
        serviceName: serviceName,
        waterfall: waterfall,
        showCriticalPath: showCriticalPath,
        onShowCriticalPathChange: onShowCriticalPathChange
      })
    },
    [TransactionTab.metadata]: {
      label: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.metadataLabel', {
        defaultMessage: 'Metadata'
      }),
      component: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, transaction && /*#__PURE__*/_react.default.createElement(MetadataTabContent, {
        transaction: transaction
      }))
    },
    [TransactionTab.logs]: {
      label: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.logsLabel', {
        defaultMessage: 'Logs'
      }),
      component: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, transaction && /*#__PURE__*/_react.default.createElement(LogsTabContent, {
        timestamp: transaction.timestamp.us,
        duration: transaction.transaction.duration.us,
        traceId: transaction.trace.id
      }))
    }
  }), [onShowCriticalPathChange, serviceName, showCriticalPath, transaction, waterfall, waterfallItemId]);
  const currentTab = tabs[detailTab];
  const TabContent = currentTab.component;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, Object.keys(TransactionTab).map(key => {
    const {
      label
    } = tabs[key];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        onTabClick(key);
      },
      isSelected: detailTab === key,
      key: key
    }, label);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isLoading || !transaction ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    "data-test-sub": "loading-content"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", TabContent));
}
function TimelineTabContent({
  waterfall,
  waterfallItemId,
  serviceName,
  showCriticalPath,
  onShowCriticalPathChange
}) {
  return /*#__PURE__*/_react.default.createElement(_waterfall_container.WaterfallContainer, {
    waterfallItemId: waterfallItemId,
    serviceName: serviceName,
    waterfall: waterfall,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange
  });
}
function MetadataTabContent({
  transaction
}) {
  return /*#__PURE__*/_react.default.createElement(_transaction_metadata.TransactionMetadata, {
    transaction: transaction
  });
}
function LogsTabContent({
  timestamp,
  duration,
  traceId
}) {
  const startTimestamp = Math.floor(timestamp / 1000);
  const endTimestamp = Math.ceil(startTimestamp + duration / 1000);
  const framePaddingMs = 1000 * 60 * 60 * 24; // 24 hours
  return /*#__PURE__*/_react.default.createElement(_public.LogStream, {
    logView: {
      type: 'log-view-reference',
      logViewId: 'default'
    },
    startTimestamp: startTimestamp - framePaddingMs,
    endTimestamp: endTimestamp + framePaddingMs,
    query: `trace.id:"${traceId}" OR (not trace.id:* AND "${traceId}")`,
    height: 640,
    columns: [{
      type: 'timestamp'
    }, {
      type: 'field',
      field: 'service.name',
      header: _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.logs.serviceName', {
        defaultMessage: 'Service Name'
      }),
      width: 200
    }, {
      type: 'message'
    }],
    showFlyoutAction: true
  });
}