"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDistribution = TransactionDistribution;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/observability-plugin/common");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_waterfall_fetcher = require("../use_waterfall_fetcher");
var _waterfall_with_summary = require("../waterfall_with_summary");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _duration_distribution_chart_with_scrubber = require("../../../shared/charts/duration_distribution_chart_with_scrubber");
var _resetting_height_container = require("../../../shared/height_retainer/resetting_height_container");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_transaction_distribution_chart_data = require("./use_transaction_distribution_chart_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionDistribution({
  onChartSelection,
  onClearSelection,
  selection,
  traceSamplesFetchResult
}) {
  var _waterfallFetchResult, _traceSamplesFetchRes;
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    traceId,
    transactionId
  } = urlParams;
  const {
    query: {
      rangeFrom,
      rangeTo,
      showCriticalPath,
      environment
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const history = (0, _reactRouterDom.useHistory)();
  const waterfallFetchResult = (0, _use_waterfall_fetcher.useWaterfallFetcher)({
    traceId,
    transactionId,
    start,
    end
  });
  const {
    waterfallItemId,
    detailTab
  } = urlParams;
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const markerCurrentEvent = (_waterfallFetchResult = waterfallFetchResult.waterfall.entryWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.doc.transaction.duration.us;
  const {
    chartData,
    hasData,
    percentileThresholdValue,
    status,
    totalDocCount
  } = (0, _use_transaction_distribution_chart_data.useTransactionDistributionChartData)();
  const onShowCriticalPathChange = (0, _react.useCallback)(nextShowCriticalPath => {
    (0, _url_helpers.push)(history, {
      query: {
        showCriticalPath: nextShowCriticalPath ? 'true' : 'false'
      }
    });
  }, [history]);
  const onTabClick = (0, _react.useCallback)(tab => {
    history.replace({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        detailTab: tab
      })
    });
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_resetting_height_container.ResettingHeightRetainer, {
    reset: !traceId
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmTransactionDistributionTabContent"
  }, /*#__PURE__*/_react.default.createElement(_duration_distribution_chart_with_scrubber.DurationDistributionChartWithScrubber, {
    onChartSelection: onChartSelection,
    onClearSelection: onClearSelection,
    selection: selection,
    status: status,
    markerCurrentEvent: markerCurrentEvent,
    chartData: chartData,
    totalDocCount: totalDocCount,
    hasData: hasData,
    percentileThresholdValue: percentileThresholdValue,
    eventType: _common.ProcessorEvent.transaction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_waterfall_with_summary.WaterfallWithSummary, {
    environment: environment,
    onSampleClick: sample => {
      history.push({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(history.location.search),
          transactionId: sample.transactionId,
          traceId: sample.traceId
        })
      });
    },
    onTabClick: onTabClick,
    serviceName: serviceName,
    waterfallItemId: waterfallItemId,
    detailTab: detailTab,
    waterfallFetchResult: waterfallFetchResult,
    traceSamplesFetchStatus: traceSamplesFetchResult.status,
    traceSamples: (_traceSamplesFetchRes = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes === void 0 ? void 0 : _traceSamplesFetchRes.traceSamples,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange
  })));
}