"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardFooterContent = CardFooterContent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _apm_link = require("../../../../shared/links/apm/apm_link");
var _kibana = require("../../../../shared/links/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CardFooterContent() {
  const fleetCloudAgentPolicyHref = (0, _kibana.useFleetCloudAgentPolicyHref)();
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmCardFooterContentViewTheApmIntegrationInFleetButton",
    href: fleetCloudAgentPolicyHref
  }, _i18n.i18n.translate('xpack.apm.settings.schema.success.viewIntegrationInFleet.buttonText', {
    defaultMessage: 'View the APM integration in Fleet'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.settings.schema.success.returnText",
    defaultMessage: "or simply return to the {serviceInventoryLink}.",
    values: {
      serviceInventoryLink: /*#__PURE__*/_react.default.createElement(_apm_link.LegacyAPMLink, {
        path: "/services"
      }, _i18n.i18n.translate('xpack.apm.settings.schema.success.returnText.serviceInventoryLink', {
        defaultMessage: 'Service inventory'
      }))
    }
  }))));
}