"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentKeysTable = AgentKeysTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _timestamp_tooltip = require("../../../shared/timestamp_tooltip");
var _confirm_delete_modal = require("./confirm_delete_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentKeysTable({
  agentKeys,
  onKeyDelete
}) {
  const [agentKeyToBeDeleted, setAgentKeyToBeDeleted] = (0, _react.useState)();
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.nameColumnName', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    field: 'username',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.userNameColumnName', {
      defaultMessage: 'User'
    }),
    sortable: true
  }, {
    field: 'realm',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.realmColumnName', {
      defaultMessage: 'Realm'
    }),
    sortable: true
  }, {
    field: 'creation',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.creationColumnName', {
      defaultMessage: 'Created'
    }),
    dataType: 'date',
    sortable: true,
    mobileOptions: {
      show: false
    },
    render: date => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: date
    })
  }, {
    actions: [{
      name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.deleteActionTitle', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.deleteActionDescription', {
        defaultMessage: 'Delete this APM agent key'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: agentKey => setAgentKeyToBeDeleted(agentKey)
    }]
  }];
  const search = {
    box: {
      incremental: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'username',
      name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.userFilterLabel', {
        defaultMessage: 'User'
      }),
      multiSelect: 'or',
      operator: 'exact',
      options: Object.keys(agentKeys.reduce((acc, {
        username
      }) => {
        acc[username] = true;
        return acc;
      }, {})).map(value => ({
        value
      }))
    }, {
      type: 'field_value_selection',
      field: 'realm',
      name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.realmFilterLabel', {
        defaultMessage: 'Realm'
      }),
      multiSelect: 'or',
      operator: 'exact',
      options: Object.keys(agentKeys.reduce((acc, {
        realm
      }) => {
        acc[realm] = true;
        return acc;
      }, {})).map(value => ({
        value
      }))
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('xpack.apm.settings.agentKeys.tableCaption', {
      defaultMessage: 'APM agent keys'
    }),
    items: agentKeys !== null && agentKeys !== void 0 ? agentKeys : [],
    columns: columns,
    pagination: true,
    search: search,
    sorting: true
  }), agentKeyToBeDeleted && /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
    onCancel: () => setAgentKeyToBeDeleted(undefined),
    agentKey: agentKeyToBeDeleted,
    onConfirm: () => {
      setAgentKeyToBeDeleted(undefined);
      onKeyDelete();
    }
  }));
}