"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigurationCreateEdit = AgentConfigurationCreateEdit;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../../shared/links/url_helpers");
var _service_page = require("./service_page/service_page");
var _settings_page = require("./settings_page/settings_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInitialNewConfig(existingConfig) {
  return {
    agent_name: existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.agent_name,
    service: (existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.service) || {},
    settings: (existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.settings) || {}
  };
}
function setPage(pageStep, history) {
  history.push({
    ...history.location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(history.location.search),
      pageStep
    })
  });
}
function getUnsavedChanges({
  newConfig,
  existingConfig
}) {
  return Object.fromEntries(Object.entries(newConfig.settings).filter(([key, value]) => {
    var _existingConfig$setti;
    const existingValue = existingConfig === null || existingConfig === void 0 ? void 0 : (_existingConfig$setti = existingConfig.settings) === null || _existingConfig$setti === void 0 ? void 0 : _existingConfig$setti[key];

    // don't highlight changes that were added and removed
    if (value === '' && existingValue == null) {
      return false;
    }
    return existingValue !== value;
  }));
}
function AgentConfigurationCreateEdit({
  pageStep,
  existingConfigResult
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const existingConfig = existingConfigResult === null || existingConfigResult === void 0 ? void 0 : existingConfigResult.data;
  const isEditMode = Boolean(existingConfigResult);
  const [newConfig, setNewConfig] = (0, _react.useState)(getInitialNewConfig(existingConfig));
  const resetSettings = (0, _react.useCallback)(() => {
    setNewConfig(_newConfig => ({
      ..._newConfig,
      settings: (existingConfig === null || existingConfig === void 0 ? void 0 : existingConfig.settings) || {}
    }));
  }, [existingConfig]);

  // update newConfig when existingConfig has loaded
  (0, _react.useEffect)(() => {
    setNewConfig(getInitialNewConfig(existingConfig));
  }, [existingConfig]);
  (0, _react.useEffect)(() => {
    // the user tried to edit the service of an existing config
    if (pageStep === 'choose-service-step' && isEditMode) {
      setPage('choose-settings-step', history);
    }

    // the user skipped the first step (select service)
    if (pageStep === 'choose-settings-step' && !isEditMode && (0, _lodash.isEmpty)(newConfig.service)) {
      setPage('choose-service-step', history);
    }
  }, [history, isEditMode, newConfig, pageStep]);
  const unsavedChanges = getUnsavedChanges({
    newConfig,
    existingConfig
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.agentConfig.newConfig.description', {
    defaultMessage: `Fine-tune your agent configuration from within the APM app. Changes are automatically propagated to your APM agents, so there’s no need to redeploy.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isEditMode ? _i18n.i18n.translate('xpack.apm.agentConfig.editConfigTitle', {
    defaultMessage: 'Edit configuration'
  }) : _i18n.i18n.translate('xpack.apm.agentConfig.createConfigTitle', {
    defaultMessage: 'Create configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), pageStep === 'choose-service-step' && /*#__PURE__*/_react.default.createElement(_service_page.ServicePage, {
    newConfig: newConfig,
    setNewConfig: setNewConfig,
    onClickNext: () => {
      resetSettings();
      setPage('choose-settings-step', history);
    }
  }), pageStep === 'choose-settings-step' && /*#__PURE__*/_react.default.createElement(_settings_page.SettingsPage, {
    status: existingConfigResult === null || existingConfigResult === void 0 ? void 0 : existingConfigResult.status,
    unsavedChanges: unsavedChanges,
    onClickEdit: () => setPage('choose-service-step', history),
    newConfig: newConfig,
    setNewConfig: setNewConfig,
    resetSettings: resetSettings,
    isEditMode: isEditMode
  }));
}