"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewInstancesTable = ServiceOverviewInstancesTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _service_overview_instances_chart_and_table = require("../service_overview_instances_chart_and_table");
var _overview_table_container = require("../../../shared/overview_table_container");
var _get_columns = require("./get_columns");
var _intance_details = require("./intance_details");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceOverviewInstancesTable({
  mainStatsItems = [],
  mainStatsItemCount,
  serviceName,
  mainStatsStatus: status,
  tableOptions,
  onChangeTableOptions,
  detailedStatsLoading,
  detailedStatsData: detailedStatsData,
  isLoading,
  isNotInitiated
}) {
  const {
    agentName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      kuery,
      latencyAggregationType,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const [itemIdToOpenActionMenuRowMap, setItemIdToOpenActionMenuRowMap] = (0, _react.useState)({});
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    // Closes any open rows when fetching new items
    setItemIdToExpandedRowMap({});
  }, [status]);
  const {
    pageIndex,
    sort
  } = tableOptions;
  const {
    direction,
    field
  } = sort;
  const toggleRowActionMenu = selectedServiceNodeName => {
    const actionMenuRowMapValues = {
      ...itemIdToOpenActionMenuRowMap
    };
    if (actionMenuRowMapValues[selectedServiceNodeName]) {
      delete actionMenuRowMapValues[selectedServiceNodeName];
    } else {
      actionMenuRowMapValues[selectedServiceNodeName] = true;
    }
    setItemIdToOpenActionMenuRowMap(actionMenuRowMapValues);
  };
  const toggleRowDetails = selectedServiceNodeName => {
    const expandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (expandedRowMapValues[selectedServiceNodeName]) {
      delete expandedRowMapValues[selectedServiceNodeName];
    } else {
      expandedRowMapValues[selectedServiceNodeName] = /*#__PURE__*/_react.default.createElement(_intance_details.InstanceDetails, {
        serviceNodeName: selectedServiceNodeName,
        serviceName: serviceName,
        kuery: kuery
      });
    }
    setItemIdToExpandedRowMap(expandedRowMapValues);
  };

  // Hide the spark plots if we're below 1600 px
  const {
    isXl
  } = (0, _use_breakpoints.useBreakpoints)();
  const shouldShowSparkPlots = !isXl;
  const columns = (0, _get_columns.getColumns)({
    agentName,
    serviceName,
    kuery,
    latencyAggregationType: latencyAggregationType,
    detailedStatsLoading,
    detailedStatsData,
    comparisonEnabled,
    toggleRowDetails,
    itemIdToExpandedRowMap,
    toggleRowActionMenu,
    itemIdToOpenActionMenuRowMap,
    shouldShowSparkPlots,
    offset
  });
  const pagination = {
    pageIndex,
    pageSize: _service_overview_instances_chart_and_table.PAGE_SIZE,
    totalItemCount: mainStatsItemCount,
    showPerPageOptions: false
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "serviceOverviewInstancesTable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableTitle', {
    defaultMessage: 'Instances'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "serviceInstancesTableContainer"
  }, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: true,
    isEmptyAndNotInitiated: mainStatsItemCount === 0 && isNotInitiated
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    noItemsMessage: status === _use_fetcher.FETCH_STATUS.LOADING ? _i18n.i18n.translate('xpack.apm.serviceOverview.loadingText', {
      defaultMessage: 'Loading…'
    }) : _i18n.i18n.translate('xpack.apm.serviceOverview.noResultsText', {
      defaultMessage: 'No instances found'
    }),
    "data-test-subj": "instancesTable",
    loading: isLoading,
    items: mainStatsItems,
    columns: columns,
    pagination: pagination,
    sorting: {
      sort: {
        field,
        direction
      }
    },
    onChange: onChangeTableOptions,
    itemId: "serviceNodeName",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : ''
  }))));
}